# Code generated by Kucoin Universal SDK Generator; DO NOT EDIT.

from abc import ABC, abstractmethod
from typing import Any
from kucoin_universal_sdk.internal.interfaces.transport import Transport
from .model_get_current_funding_rate_req import GetCurrentFundingRateReq
from .model_get_current_funding_rate_resp import GetCurrentFundingRateResp
from .model_get_private_funding_history_req import GetPrivateFundingHistoryReq
from .model_get_private_funding_history_resp import GetPrivateFundingHistoryResp
from .model_get_public_funding_history_req import GetPublicFundingHistoryReq
from .model_get_public_funding_history_resp import GetPublicFundingHistoryResp


class FundingFeesAPI(ABC):

    @abstractmethod
    def get_current_funding_rate(self, req: GetCurrentFundingRateReq,
                                 **kwargs: Any) -> GetCurrentFundingRateResp:
        """
        summary: Get Current Funding Rate.
        description: Get Current Funding Rate.
        documentation: https://www.kucoin.com/docs-new/api-3470265
        +-----------------------+---------+
        | Extra API Info        | Value   |
        +-----------------------+---------+
        | API-DOMAIN            | FUTURES |
        | API-CHANNEL           | PUBLIC  |
        | API-PERMISSION        | FUTURES |
        | API-RATE-LIMIT-POOL   | PUBLIC  |
        | API-RATE-LIMIT-WEIGHT | 2       |
        +-----------------------+---------+
        """
        pass

    @abstractmethod
    def get_public_funding_history(
            self, req: GetPublicFundingHistoryReq,
            **kwargs: Any) -> GetPublicFundingHistoryResp:
        """
        summary: Get Public Funding History
        description: Query the funding rate at each settlement time point within a certain time range of the corresponding contract.
        documentation: https://www.kucoin.com/docs-new/api-3470266
        +-----------------------+---------+
        | Extra API Info        | Value   |
        +-----------------------+---------+
        | API-DOMAIN            | FUTURES |
        | API-CHANNEL           | PUBLIC  |
        | API-PERMISSION        | FUTURES |
        | API-RATE-LIMIT-POOL   | PUBLIC  |
        | API-RATE-LIMIT-WEIGHT | 5       |
        +-----------------------+---------+
        """
        pass

    @abstractmethod
    def get_private_funding_history(
            self, req: GetPrivateFundingHistoryReq,
            **kwargs: Any) -> GetPrivateFundingHistoryResp:
        """
        summary: Get Private Funding History
        description: Submit request to get the funding history.
        documentation: https://www.kucoin.com/docs-new/api-3470267
        +-----------------------+---------+
        | Extra API Info        | Value   |
        +-----------------------+---------+
        | API-DOMAIN            | FUTURES |
        | API-CHANNEL           | PRIVATE |
        | API-PERMISSION        | FUTURES |
        | API-RATE-LIMIT-POOL   | FUTURES |
        | API-RATE-LIMIT-WEIGHT | 5       |
        +-----------------------+---------+
        """
        pass


class FundingFeesAPIImpl(FundingFeesAPI):

    def __init__(self, transport: Transport):
        self.transport = transport

    def get_current_funding_rate(self, req: GetCurrentFundingRateReq,
                                 **kwargs: Any) -> GetCurrentFundingRateResp:
        return self.transport.call("futures", False, "GET",
                                   "/api/v1/funding-rate/{symbol}/current",
                                   req, GetCurrentFundingRateResp(), False,
                                   **kwargs)

    def get_public_funding_history(
            self, req: GetPublicFundingHistoryReq,
            **kwargs: Any) -> GetPublicFundingHistoryResp:
        return self.transport.call("futures", False, "GET",
                                   "/api/v1/contract/funding-rates", req,
                                   GetPublicFundingHistoryResp(), False,
                                   **kwargs)

    def get_private_funding_history(
            self, req: GetPrivateFundingHistoryReq,
            **kwargs: Any) -> GetPrivateFundingHistoryResp:
        return self.transport.call("futures", False, "GET",
                                   "/api/v1/funding-history", req,
                                   GetPrivateFundingHistoryResp(), False,
                                   **kwargs)
