# coding: utf-8

# Code generated by Kucoin Universal SDK Generator; DO NOT EDIT.

from __future__ import annotations
import pprint
import json

from pydantic import BaseModel, ConfigDict, Field
from typing import Any, ClassVar, Dict, List, Optional
from kucoin_universal_sdk.internal.interfaces.response import Response
from kucoin_universal_sdk.model.common import RestResponse


class GetCurrentFundingRateResp(BaseModel, Response):
    """
    GetCurrentFundingRateResp

    Attributes:
        symbol (str): Funding Rate Symbol 
        granularity (int): Granularity (milliseconds) 
        time_point (int): The funding rate settlement time point of the previous cycle (milliseconds) 
        value (float): Current cycle funding rate 
        predicted_value (float): Predicted funding rate 
        funding_rate_cap (float): Maximum Funding Rate
        funding_rate_floor (float): Minimum Funding Rate
    """

    common_response: Optional[RestResponse] = Field(
        default=None, description="Common response")
    symbol: Optional[str] = Field(default=None,
                                  description="Funding Rate Symbol ")
    granularity: Optional[int] = Field(
        default=None, description="Granularity (milliseconds) ")
    time_point: Optional[int] = Field(
        default=None,
        description=
        "The funding rate settlement time point of the previous cycle (milliseconds) ",
        alias="timePoint")
    value: Optional[float] = Field(default=None,
                                   description="Current cycle funding rate ")
    predicted_value: Optional[float] = Field(
        default=None,
        description="Predicted funding rate ",
        alias="predictedValue")
    funding_rate_cap: Optional[float] = Field(
        default=None,
        description="Maximum Funding Rate",
        alias="fundingRateCap")
    funding_rate_floor: Optional[float] = Field(
        default=None,
        description="Minimum Funding Rate",
        alias="fundingRateFloor")

    __properties: ClassVar[List[str]] = [
        "symbol", "granularity", "timePoint", "value", "predictedValue",
        "fundingRateCap", "fundingRateFloor"
    ]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=False,
        protected_namespaces=(),
    )

    def to_str(self) -> str:
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        return self.model_dump_json(by_alias=True, exclude_none=True)

    @classmethod
    def from_json(cls, json_str: str) -> Optional[GetCurrentFundingRateResp]:
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        _dict = self.model_dump(
            by_alias=True,
            exclude_none=True,
        )
        return _dict

    @classmethod
    def from_dict(
            cls,
            obj: Optional[Dict[str,
                               Any]]) -> Optional[GetCurrentFundingRateResp]:
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "symbol":
            obj.get("symbol"),
            "granularity":
            obj.get("granularity"),
            "timePoint":
            obj.get("timePoint"),
            "value":
            obj.get("value"),
            "predictedValue":
            obj.get("predictedValue"),
            "fundingRateCap":
            obj.get("fundingRateCap"),
            "fundingRateFloor":
            obj.get("fundingRateFloor")
        })
        return _obj

    def set_common_response(self, response: RestResponse):
        self.common_response = response
