# coding: utf-8

# Code generated by Kucoin Universal SDK Generator; DO NOT EDIT.

from __future__ import annotations
import pprint
import json

from enum import Enum
from pydantic import BaseModel, ConfigDict, Field
from typing import Any, Callable, ClassVar, Dict, List, Optional
from kucoin_universal_sdk.internal.interfaces.websocket import WebSocketMessageCallback
from kucoin_universal_sdk.model.common import WsMessage


class StopOrdersEvent(BaseModel):
    """
    StopOrdersEvent

    Attributes:
        created_at (int): 
        margin_mode (MarginModeEnum): Margin Mode
        order_id (str): The unique order id generated by the trading system
        order_price (str): Order Price
        order_type (OrderTypeEnum): User-specified order type
        side (SideEnum): buy or sell
        size (int): User-specified order size
        stop (StopEnum): Either 'down' or 'up'
        stop_price (str): Stop Price
        stop_price_type (str): 
        symbol (str): Symbol of the contract. Please refer to [Get Symbol endpoint: symbol](https://www.kucoin.com/docs-new/api-221752070) 
        ts (int): 
        type (TypeEnum): Order Type
    """

    class MarginModeEnum(Enum):
        """
        Attributes:
            ISOLATED: Isolated Margin
            CROSS: Cross Margin
        """
        ISOLATED = 'ISOLATED'
        CROSS = 'CROSS'

    class OrderTypeEnum(Enum):
        """
        Attributes:
            STOP: Stop order
        """
        STOP = 'stop'

    class SideEnum(Enum):
        """
        Attributes:
            BUY: buy
            SELL: sell
        """
        BUY = 'buy'
        SELL = 'sell'

    class StopEnum(Enum):
        """
        Attributes:
            DOWN: Triggers when the price reaches or goes below the stopPrice
            UP: Triggers when the price reaches or goes above the stopPrice.
        """
        DOWN = 'down'
        UP = 'up'

    class TypeEnum(Enum):
        """
        Attributes:
            OPEN: the order is in the order book (maker order)
            TRIGGERED: when the stop order has been triggered
            CANCEL: when the order has been canceled
        """
        OPEN = 'open'
        TRIGGERED = 'triggered'
        CANCEL = 'cancel'

    common_response: Optional[WsMessage] = Field(default=None,
                                                 description="Common response")
    created_at: Optional[int] = Field(default=None, alias="createdAt")
    margin_mode: Optional[MarginModeEnum] = Field(default=None,
                                                  description="Margin Mode",
                                                  alias="marginMode")
    order_id: Optional[str] = Field(
        default=None,
        description="The unique order id generated by the trading system",
        alias="orderId")
    order_price: Optional[str] = Field(default=None,
                                       description="Order Price",
                                       alias="orderPrice")
    order_type: Optional[OrderTypeEnum] = Field(
        default=None,
        description="User-specified order type",
        alias="orderType")
    side: Optional[SideEnum] = Field(default=None, description="buy or sell")
    size: Optional[int] = Field(default=None,
                                description="User-specified order size")
    stop: Optional[StopEnum] = Field(default=None,
                                     description="Either 'down' or 'up'")
    stop_price: Optional[str] = Field(default=None,
                                      description="Stop Price",
                                      alias="stopPrice")
    stop_price_type: Optional[str] = Field(default=None, alias="stopPriceType")
    symbol: Optional[str] = Field(
        default=None,
        description=
        "Symbol of the contract. Please refer to [Get Symbol endpoint: symbol](https://www.kucoin.com/docs-new/api-221752070) "
    )
    ts: Optional[int] = None
    type: Optional[TypeEnum] = Field(default=None, description="Order Type")

    __properties: ClassVar[List[str]] = [
        "createdAt", "marginMode", "orderId", "orderPrice", "orderType",
        "side", "size", "stop", "stopPrice", "stopPriceType", "symbol", "ts",
        "type"
    ]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=False,
        protected_namespaces=(),
    )

    def to_str(self) -> str:
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        return self.model_dump_json(by_alias=True, exclude_none=True)

    @classmethod
    def from_json(cls, json_str: str) -> Optional[StopOrdersEvent]:
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        _dict = self.model_dump(
            by_alias=True,
            exclude_none=True,
        )
        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str,
                                          Any]]) -> Optional[StopOrdersEvent]:
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "createdAt": obj.get("createdAt"),
            "marginMode": obj.get("marginMode"),
            "orderId": obj.get("orderId"),
            "orderPrice": obj.get("orderPrice"),
            "orderType": obj.get("orderType"),
            "side": obj.get("side"),
            "size": obj.get("size"),
            "stop": obj.get("stop"),
            "stopPrice": obj.get("stopPrice"),
            "stopPriceType": obj.get("stopPriceType"),
            "symbol": obj.get("symbol"),
            "ts": obj.get("ts"),
            "type": obj.get("type")
        })
        return _obj


StopOrdersEventCallback = Callable[[str, str, StopOrdersEvent], None]
"""
args:
    - topic (str) : topic
    - subject (str): subject
    - data (StopOrdersEvent): event data
"""


class StopOrdersEventCallbackWrapper(WebSocketMessageCallback):

    def __init__(self, cb: StopOrdersEventCallback):
        self.callback = cb

    def on_message(self, message: WsMessage):
        event = StopOrdersEvent.from_dict(message.raw_data)
        event.common_response = message
        self.callback(message.topic, message.subject, event)
