# coding: utf-8

# Code generated by Kucoin Universal SDK Generator; DO NOT EDIT.

from __future__ import annotations
import pprint
import json

from pydantic import BaseModel, ConfigDict, Field
from typing import Any, Callable, ClassVar, Dict, List, Optional
from kucoin_universal_sdk.internal.interfaces.websocket import WebSocketMessageCallback
from kucoin_universal_sdk.model.common import WsMessage


class AnnouncementEvent(BaseModel):
    """
    AnnouncementEvent

    Attributes:
        symbol (str): Symbol
        funding_time (int): Funding time
        funding_rate (float): Funding rate
        timestamp (int): 
    """

    common_response: Optional[WsMessage] = Field(default=None,
                                                 description="Common response")
    symbol: Optional[str] = Field(default=None, description="Symbol")
    funding_time: Optional[int] = Field(default=None,
                                        description="Funding time",
                                        alias="fundingTime")
    funding_rate: Optional[float] = Field(default=None,
                                          description="Funding rate",
                                          alias="fundingRate")
    timestamp: Optional[int] = None

    __properties: ClassVar[List[str]] = [
        "symbol", "fundingTime", "fundingRate", "timestamp"
    ]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=False,
        protected_namespaces=(),
    )

    def to_str(self) -> str:
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        return self.model_dump_json(by_alias=True, exclude_none=True)

    @classmethod
    def from_json(cls, json_str: str) -> Optional[AnnouncementEvent]:
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        _dict = self.model_dump(
            by_alias=True,
            exclude_none=True,
        )
        return _dict

    @classmethod
    def from_dict(
            cls, obj: Optional[Dict[str, Any]]) -> Optional[AnnouncementEvent]:
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "symbol": obj.get("symbol"),
            "fundingTime": obj.get("fundingTime"),
            "fundingRate": obj.get("fundingRate"),
            "timestamp": obj.get("timestamp")
        })
        return _obj


AnnouncementEventCallback = Callable[[str, str, AnnouncementEvent], None]
"""
args:
    - topic (str) : topic
    - subject (str): subject
    - data (AnnouncementEvent): event data
"""


class AnnouncementEventCallbackWrapper(WebSocketMessageCallback):

    def __init__(self, cb: AnnouncementEventCallback):
        self.callback = cb

    def on_message(self, message: WsMessage):
        event = AnnouncementEvent.from_dict(message.raw_data)
        event.common_response = message
        self.callback(message.topic, message.subject, event)
