# coding: utf-8

# Code generated by Kucoin Universal SDK Generator; DO NOT EDIT.

from __future__ import annotations
import pprint
import json

from pydantic import BaseModel, ConfigDict, Field
from typing import Any, Callable, ClassVar, Dict, List, Optional
from typing_extensions import Annotated
from kucoin_universal_sdk.internal.interfaces.websocket import WebSocketMessageCallback
from kucoin_universal_sdk.model.common import WsMessage


class OrderbookLevel5Event(BaseModel):
    """
    OrderbookLevel5Event

    Attributes:
        bids (list[list[object]]): 
        sequence (int): 
        timestamp (int): 
        ts (int): 
        asks (list[list[object]]): 
    """

    common_response: Optional[WsMessage] = Field(default=None,
                                                 description="Common response")
    bids: Optional[List[Annotated[List[Any],
                                  Field(min_length=2, max_length=2)]]] = None
    sequence: Optional[int] = None
    timestamp: Optional[int] = None
    ts: Optional[int] = None
    asks: Optional[List[Annotated[List[Any],
                                  Field(min_length=2, max_length=2)]]] = None

    __properties: ClassVar[List[str]] = [
        "bids", "sequence", "timestamp", "ts", "asks"
    ]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=False,
        protected_namespaces=(),
    )

    def to_str(self) -> str:
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        return self.model_dump_json(by_alias=True, exclude_none=True)

    @classmethod
    def from_json(cls, json_str: str) -> Optional[OrderbookLevel5Event]:
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        _dict = self.model_dump(
            by_alias=True,
            exclude_none=True,
        )
        return _dict

    @classmethod
    def from_dict(
            cls, obj: Optional[Dict[str,
                                    Any]]) -> Optional[OrderbookLevel5Event]:
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "bids": obj.get("bids"),
            "sequence": obj.get("sequence"),
            "timestamp": obj.get("timestamp"),
            "ts": obj.get("ts"),
            "asks": obj.get("asks")
        })
        return _obj


OrderbookLevel5EventCallback = Callable[[str, str, OrderbookLevel5Event], None]
"""
args:
    - topic (str) : topic
    - subject (str): subject
    - data (OrderbookLevel5Event): event data
"""


class OrderbookLevel5EventCallbackWrapper(WebSocketMessageCallback):

    def __init__(self, cb: OrderbookLevel5EventCallback):
        self.callback = cb

    def on_message(self, message: WsMessage):
        event = OrderbookLevel5Event.from_dict(message.raw_data)
        event.common_response = message
        self.callback(message.topic, message.subject, event)
