# coding: utf-8

# Code generated by Kucoin Universal SDK Generator; DO NOT EDIT.

from __future__ import annotations
import pprint
import json

from pydantic import BaseModel, ConfigDict, Field
from typing import Any, Callable, ClassVar, Dict, List, Optional
from kucoin_universal_sdk.internal.interfaces.websocket import WebSocketMessageCallback
from kucoin_universal_sdk.model.common import WsMessage


class SymbolSnapshotEvent(BaseModel):
    """
    SymbolSnapshotEvent

    Attributes:
        high_price (float): 
        last_price (float): 
        low_price (float): 
        price24_hours_before (float): 
        price_chg (float): 
        price_chg_pct (float): 
        symbol (str): 
        ts (int): 
        turnover (float): 
        volume (float): 
    """

    common_response: Optional[WsMessage] = Field(default=None,
                                                 description="Common response")
    high_price: Optional[float] = Field(default=None, alias="highPrice")
    last_price: Optional[float] = Field(default=None, alias="lastPrice")
    low_price: Optional[float] = Field(default=None, alias="lowPrice")
    price24_hours_before: Optional[float] = Field(default=None,
                                                  alias="price24HoursBefore")
    price_chg: Optional[float] = Field(default=None, alias="priceChg")
    price_chg_pct: Optional[float] = Field(default=None, alias="priceChgPct")
    symbol: Optional[str] = None
    ts: Optional[int] = None
    turnover: Optional[float] = None
    volume: Optional[float] = None

    __properties: ClassVar[List[str]] = [
        "highPrice", "lastPrice", "lowPrice", "price24HoursBefore", "priceChg",
        "priceChgPct", "symbol", "ts", "turnover", "volume"
    ]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=False,
        protected_namespaces=(),
    )

    def to_str(self) -> str:
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        return self.model_dump_json(by_alias=True, exclude_none=True)

    @classmethod
    def from_json(cls, json_str: str) -> Optional[SymbolSnapshotEvent]:
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        _dict = self.model_dump(
            by_alias=True,
            exclude_none=True,
        )
        return _dict

    @classmethod
    def from_dict(
            cls, obj: Optional[Dict[str,
                                    Any]]) -> Optional[SymbolSnapshotEvent]:
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "highPrice":
            obj.get("highPrice"),
            "lastPrice":
            obj.get("lastPrice"),
            "lowPrice":
            obj.get("lowPrice"),
            "price24HoursBefore":
            obj.get("price24HoursBefore"),
            "priceChg":
            obj.get("priceChg"),
            "priceChgPct":
            obj.get("priceChgPct"),
            "symbol":
            obj.get("symbol"),
            "ts":
            obj.get("ts"),
            "turnover":
            obj.get("turnover"),
            "volume":
            obj.get("volume")
        })
        return _obj


SymbolSnapshotEventCallback = Callable[[str, str, SymbolSnapshotEvent], None]
"""
args:
    - topic (str) : topic
    - subject (str): subject
    - data (SymbolSnapshotEvent): event data
"""


class SymbolSnapshotEventCallbackWrapper(WebSocketMessageCallback):

    def __init__(self, cb: SymbolSnapshotEventCallback):
        self.callback = cb

    def on_message(self, message: WsMessage):
        event = SymbolSnapshotEvent.from_dict(message.raw_data)
        event.common_response = message
        self.callback(message.topic, message.subject, event)
