# coding: utf-8

# Code generated by Kucoin Universal SDK Generator; DO NOT EDIT.

from __future__ import annotations
import pprint
import json

from enum import Enum
from pydantic import BaseModel, ConfigDict, Field
from typing import Any, ClassVar, Dict, List, Optional


class GetAllSymbolsData(BaseModel):
    """
    GetAllSymbolsData

    Attributes:
        symbol (str): Symbol
        root_symbol (str): Contract group
        type (TypeEnum): Type of contract
        first_open_date (int): First Open Date (milliseconds)
        expire_date (int): Expiration date (milliseconds) Null means it will never expire
        settle_date (int): Settlement date (milliseconds) Null indicates that automatic settlement is not supported
        base_currency (str): Base currency
        quote_currency (str): Quote currency
        settle_currency (str): Currency used to clear and settle the trades
        max_order_qty (int): Maximum order quantity
        max_price (float): Maximum order price
        lot_size (int): Minimum lot size
        tick_size (float): Minimum price changes
        index_price_tick_size (float): Index price of tick size
        multiplier (float): The basic unit of the contract API is lots. For the number of coins in each lot, please refer to the param multiplier. For example, for XBTUSDTM, multiplier=0.001, which corresponds to the value of each XBTUSDTM contract being 0.001 BTC. There is also a special case. All coin-swap contracts, such as each XBTUSDM contract, correspond to 1 USD.
        initial_margin (float): Initial margin requirement
        maintain_margin (float): Maintenance margin requirement
        max_risk_limit (int): Maximum risk limit (unit: XBT)
        min_risk_limit (int): Minimum risk limit (unit: XBT)
        risk_step (int): Risk limit increment value (unit: XBT)
        maker_fee_rate (float): Maker fee rate
        taker_fee_rate (float): Taker fee rate
        taker_fix_fee (float): Deprecated param
        maker_fix_fee (float): Deprecated param
        settlement_fee (float): Settlement fee
        is_deleverage (bool): Enabled ADL or not
        is_quanto (bool): Deprecated param
        is_inverse (bool): Whether it is a reverse contract
        mark_method (MarkMethodEnum): Marking method
        fair_method (FairMethodEnum): Fair price marking method; the Futures contract is null
        funding_base_symbol (str): Ticker symbol of the base currency
        funding_quote_symbol (str): Ticker symbol of the quote currency
        funding_rate_symbol (str): Funding rate symbol
        index_symbol (str): Index symbol
        settlement_symbol (str): Settlement symbol
        status (StatusEnum): Contract status
        funding_fee_rate (float): Funding fee rate
        predicted_funding_fee_rate (float): Predicted funding fee rate
        funding_rate_granularity (int): Funding interval (milliseconds)
        open_interest (str): Open interest (unit: lots)
        turnover_of24h (float): 24-hour turnover
        volume_of24h (float): 24-hour volume
        mark_price (float): Mark price
        index_price (float): Index price
        last_trade_price (float): Last trade price
        next_funding_rate_time (int): Next funding rate time (milliseconds)
        max_leverage (int): Maximum leverage
        source_exchanges (list[str]): The contract index price source exchange
        premiums_symbol1_m (str): Premium index symbol (1 minute)
        premiums_symbol8_h (str): Premium index symbol (8 hours)
        funding_base_symbol1_m (str): Base currency interest rate symbol (1 minute)
        funding_quote_symbol1_m (str): Quote currency interest rate symbol (1 minute)
        low_price (float): 24-hour lowest price
        high_price (float): 24-hour highest price
        price_chg_pct (float): 24-hour % price change 
        price_chg (float): 24-hour price change
        k (float): 
        m (float): 
        f (float): 
        mmr_limit (float): 
        mmr_lev_constant (float): 
        support_cross (bool): Whether support Cross Margin
        buy_limit (float): The current maximum buying price allowed
        sell_limit (float): The current minimum selling price allowed
    """

    class TypeEnum(Enum):
        """
        Attributes:
            FFWCSX: Standardized swap contracts, standard financial futures on swaps, expiration swap funding rates
            FFICSX: Futures Contract
        """
        FFWCSX = 'FFWCSX'
        FFICSX = 'FFICSX'

    class MarkMethodEnum(Enum):
        """
        Attributes:
            FAIR_PRICE: FairPrice
        """
        FAIR_PRICE = 'FairPrice'

    class FairMethodEnum(Enum):
        """
        Attributes:
            FUNDING_RATE: FundingRate
        """
        FUNDING_RATE = 'FundingRate'

    class StatusEnum(Enum):
        """
        Attributes:
            INIT: Initial
            OPEN: Online
            BEING_SETTLED: Settling
            SETTLED: Settled
            PAUSED: Suspended
            CLOSED: Offline
            CANCEL_ONLY: Orders can only be canceled
        """
        INIT = 'Init'
        OPEN = 'Open'
        BEING_SETTLED = 'BeingSettled'
        SETTLED = 'Settled'
        PAUSED = 'Paused'
        CLOSED = 'Closed'
        CANCEL_ONLY = 'CancelOnly'

    symbol: Optional[str] = Field(default=None, description="Symbol")
    root_symbol: Optional[str] = Field(default=None,
                                       description="Contract group",
                                       alias="rootSymbol")
    type: Optional[TypeEnum] = Field(default=None,
                                     description="Type of contract")
    first_open_date: Optional[int] = Field(
        default=None,
        description="First Open Date (milliseconds)",
        alias="firstOpenDate")
    expire_date: Optional[int] = Field(
        default=None,
        description=
        "Expiration date (milliseconds) Null means it will never expire",
        alias="expireDate")
    settle_date: Optional[int] = Field(
        default=None,
        description=
        "Settlement date (milliseconds) Null indicates that automatic settlement is not supported",
        alias="settleDate")
    base_currency: Optional[str] = Field(default=None,
                                         description="Base currency",
                                         alias="baseCurrency")
    quote_currency: Optional[str] = Field(default=None,
                                          description="Quote currency",
                                          alias="quoteCurrency")
    settle_currency: Optional[str] = Field(
        default=None,
        description="Currency used to clear and settle the trades",
        alias="settleCurrency")
    max_order_qty: Optional[int] = Field(default=None,
                                         description="Maximum order quantity",
                                         alias="maxOrderQty")
    max_price: Optional[float] = Field(default=None,
                                       description="Maximum order price",
                                       alias="maxPrice")
    lot_size: Optional[int] = Field(default=None,
                                    description="Minimum lot size",
                                    alias="lotSize")
    tick_size: Optional[float] = Field(default=None,
                                       description="Minimum price changes",
                                       alias="tickSize")
    index_price_tick_size: Optional[float] = Field(
        default=None,
        description="Index price of tick size",
        alias="indexPriceTickSize")
    multiplier: Optional[float] = Field(
        default=None,
        description=
        "The basic unit of the contract API is lots. For the number of coins in each lot, please refer to the param multiplier. For example, for XBTUSDTM, multiplier=0.001, which corresponds to the value of each XBTUSDTM contract being 0.001 BTC. There is also a special case. All coin-swap contracts, such as each XBTUSDM contract, correspond to 1 USD."
    )
    initial_margin: Optional[float] = Field(
        default=None,
        description="Initial margin requirement",
        alias="initialMargin")
    maintain_margin: Optional[float] = Field(
        default=None,
        description="Maintenance margin requirement",
        alias="maintainMargin")
    max_risk_limit: Optional[int] = Field(
        default=None,
        description="Maximum risk limit (unit: XBT)",
        alias="maxRiskLimit")
    min_risk_limit: Optional[int] = Field(
        default=None,
        description="Minimum risk limit (unit: XBT)",
        alias="minRiskLimit")
    risk_step: Optional[int] = Field(
        default=None,
        description="Risk limit increment value (unit: XBT)",
        alias="riskStep")
    maker_fee_rate: Optional[float] = Field(default=None,
                                            description="Maker fee rate",
                                            alias="makerFeeRate")
    taker_fee_rate: Optional[float] = Field(default=None,
                                            description="Taker fee rate",
                                            alias="takerFeeRate")
    taker_fix_fee: Optional[float] = Field(default=None,
                                           description="Deprecated param",
                                           alias="takerFixFee")
    maker_fix_fee: Optional[float] = Field(default=None,
                                           description="Deprecated param",
                                           alias="makerFixFee")
    settlement_fee: Optional[float] = Field(default=None,
                                            description="Settlement fee",
                                            alias="settlementFee")
    is_deleverage: Optional[bool] = Field(default=None,
                                          description="Enabled ADL or not",
                                          alias="isDeleverage")
    is_quanto: Optional[bool] = Field(default=None,
                                      description="Deprecated param",
                                      alias="isQuanto")
    is_inverse: Optional[bool] = Field(
        default=None,
        description="Whether it is a reverse contract",
        alias="isInverse")
    mark_method: Optional[MarkMethodEnum] = Field(default=None,
                                                  description="Marking method",
                                                  alias="markMethod")
    fair_method: Optional[FairMethodEnum] = Field(
        default=None,
        description="Fair price marking method; the Futures contract is null",
        alias="fairMethod")
    funding_base_symbol: Optional[str] = Field(
        default=None,
        description="Ticker symbol of the base currency",
        alias="fundingBaseSymbol")
    funding_quote_symbol: Optional[str] = Field(
        default=None,
        description="Ticker symbol of the quote currency",
        alias="fundingQuoteSymbol")
    funding_rate_symbol: Optional[str] = Field(
        default=None,
        description="Funding rate symbol",
        alias="fundingRateSymbol")
    index_symbol: Optional[str] = Field(default=None,
                                        description="Index symbol",
                                        alias="indexSymbol")
    settlement_symbol: Optional[str] = Field(default=None,
                                             description="Settlement symbol",
                                             alias="settlementSymbol")
    status: Optional[StatusEnum] = Field(default=None,
                                         description="Contract status")
    funding_fee_rate: Optional[float] = Field(default=None,
                                              description="Funding fee rate",
                                              alias="fundingFeeRate")
    predicted_funding_fee_rate: Optional[float] = Field(
        default=None,
        description="Predicted funding fee rate",
        alias="predictedFundingFeeRate")
    funding_rate_granularity: Optional[int] = Field(
        default=None,
        description="Funding interval (milliseconds)",
        alias="fundingRateGranularity")
    open_interest: Optional[str] = Field(
        default=None,
        description="Open interest (unit: lots)",
        alias="openInterest")
    turnover_of24h: Optional[float] = Field(default=None,
                                            description="24-hour turnover",
                                            alias="turnoverOf24h")
    volume_of24h: Optional[float] = Field(default=None,
                                          description="24-hour volume",
                                          alias="volumeOf24h")
    mark_price: Optional[float] = Field(default=None,
                                        description="Mark price",
                                        alias="markPrice")
    index_price: Optional[float] = Field(default=None,
                                         description="Index price",
                                         alias="indexPrice")
    last_trade_price: Optional[float] = Field(default=None,
                                              description="Last trade price",
                                              alias="lastTradePrice")
    next_funding_rate_time: Optional[int] = Field(
        default=None,
        description="Next funding rate time (milliseconds)",
        alias="nextFundingRateTime")
    max_leverage: Optional[int] = Field(default=None,
                                        description="Maximum leverage",
                                        alias="maxLeverage")
    source_exchanges: Optional[List[str]] = Field(
        default=None,
        description="The contract index price source exchange",
        alias="sourceExchanges")
    premiums_symbol1_m: Optional[str] = Field(
        default=None,
        description="Premium index symbol (1 minute)",
        alias="premiumsSymbol1M")
    premiums_symbol8_h: Optional[str] = Field(
        default=None,
        description="Premium index symbol (8 hours)",
        alias="premiumsSymbol8H")
    funding_base_symbol1_m: Optional[str] = Field(
        default=None,
        description="Base currency interest rate symbol (1 minute)",
        alias="fundingBaseSymbol1M")
    funding_quote_symbol1_m: Optional[str] = Field(
        default=None,
        description="Quote currency interest rate symbol (1 minute)",
        alias="fundingQuoteSymbol1M")
    low_price: Optional[float] = Field(default=None,
                                       description="24-hour lowest price",
                                       alias="lowPrice")
    high_price: Optional[float] = Field(default=None,
                                        description="24-hour highest price",
                                        alias="highPrice")
    price_chg_pct: Optional[float] = Field(
        default=None,
        description="24-hour % price change ",
        alias="priceChgPct")
    price_chg: Optional[float] = Field(default=None,
                                       description="24-hour price change",
                                       alias="priceChg")
    k: Optional[float] = None
    m: Optional[float] = None
    f: Optional[float] = None
    mmr_limit: Optional[float] = Field(default=None, alias="mmrLimit")
    mmr_lev_constant: Optional[float] = Field(default=None,
                                              alias="mmrLevConstant")
    support_cross: Optional[bool] = Field(
        default=None,
        description="Whether support Cross Margin",
        alias="supportCross")
    buy_limit: Optional[float] = Field(
        default=None,
        description="The current maximum buying price allowed",
        alias="buyLimit")
    sell_limit: Optional[float] = Field(
        default=None,
        description="The current minimum selling price allowed",
        alias="sellLimit")

    __properties: ClassVar[List[str]] = [
        "symbol", "rootSymbol", "type", "firstOpenDate", "expireDate",
        "settleDate", "baseCurrency", "quoteCurrency", "settleCurrency",
        "maxOrderQty", "maxPrice", "lotSize", "tickSize", "indexPriceTickSize",
        "multiplier", "initialMargin", "maintainMargin", "maxRiskLimit",
        "minRiskLimit", "riskStep", "makerFeeRate", "takerFeeRate",
        "takerFixFee", "makerFixFee", "settlementFee", "isDeleverage",
        "isQuanto", "isInverse", "markMethod", "fairMethod",
        "fundingBaseSymbol", "fundingQuoteSymbol", "fundingRateSymbol",
        "indexSymbol", "settlementSymbol", "status", "fundingFeeRate",
        "predictedFundingFeeRate", "fundingRateGranularity", "openInterest",
        "turnoverOf24h", "volumeOf24h", "markPrice", "indexPrice",
        "lastTradePrice", "nextFundingRateTime", "maxLeverage",
        "sourceExchanges", "premiumsSymbol1M", "premiumsSymbol8H",
        "fundingBaseSymbol1M", "fundingQuoteSymbol1M", "lowPrice", "highPrice",
        "priceChgPct", "priceChg", "k", "m", "f", "mmrLimit", "mmrLevConstant",
        "supportCross", "buyLimit", "sellLimit"
    ]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=False,
        protected_namespaces=(),
    )

    def to_str(self) -> str:
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        return self.model_dump_json(by_alias=True, exclude_none=True)

    @classmethod
    def from_json(cls, json_str: str) -> Optional[GetAllSymbolsData]:
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        _dict = self.model_dump(
            by_alias=True,
            exclude_none=True,
        )
        return _dict

    @classmethod
    def from_dict(
            cls, obj: Optional[Dict[str, Any]]) -> Optional[GetAllSymbolsData]:
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "symbol":
            obj.get("symbol"),
            "rootSymbol":
            obj.get("rootSymbol"),
            "type":
            obj.get("type"),
            "firstOpenDate":
            obj.get("firstOpenDate"),
            "expireDate":
            obj.get("expireDate"),
            "settleDate":
            obj.get("settleDate"),
            "baseCurrency":
            obj.get("baseCurrency"),
            "quoteCurrency":
            obj.get("quoteCurrency"),
            "settleCurrency":
            obj.get("settleCurrency"),
            "maxOrderQty":
            obj.get("maxOrderQty"),
            "maxPrice":
            obj.get("maxPrice"),
            "lotSize":
            obj.get("lotSize"),
            "tickSize":
            obj.get("tickSize"),
            "indexPriceTickSize":
            obj.get("indexPriceTickSize"),
            "multiplier":
            obj.get("multiplier"),
            "initialMargin":
            obj.get("initialMargin"),
            "maintainMargin":
            obj.get("maintainMargin"),
            "maxRiskLimit":
            obj.get("maxRiskLimit"),
            "minRiskLimit":
            obj.get("minRiskLimit"),
            "riskStep":
            obj.get("riskStep"),
            "makerFeeRate":
            obj.get("makerFeeRate"),
            "takerFeeRate":
            obj.get("takerFeeRate"),
            "takerFixFee":
            obj.get("takerFixFee"),
            "makerFixFee":
            obj.get("makerFixFee"),
            "settlementFee":
            obj.get("settlementFee"),
            "isDeleverage":
            obj.get("isDeleverage"),
            "isQuanto":
            obj.get("isQuanto"),
            "isInverse":
            obj.get("isInverse"),
            "markMethod":
            obj.get("markMethod"),
            "fairMethod":
            obj.get("fairMethod"),
            "fundingBaseSymbol":
            obj.get("fundingBaseSymbol"),
            "fundingQuoteSymbol":
            obj.get("fundingQuoteSymbol"),
            "fundingRateSymbol":
            obj.get("fundingRateSymbol"),
            "indexSymbol":
            obj.get("indexSymbol"),
            "settlementSymbol":
            obj.get("settlementSymbol"),
            "status":
            obj.get("status"),
            "fundingFeeRate":
            obj.get("fundingFeeRate"),
            "predictedFundingFeeRate":
            obj.get("predictedFundingFeeRate"),
            "fundingRateGranularity":
            obj.get("fundingRateGranularity"),
            "openInterest":
            obj.get("openInterest"),
            "turnoverOf24h":
            obj.get("turnoverOf24h"),
            "volumeOf24h":
            obj.get("volumeOf24h"),
            "markPrice":
            obj.get("markPrice"),
            "indexPrice":
            obj.get("indexPrice"),
            "lastTradePrice":
            obj.get("lastTradePrice"),
            "nextFundingRateTime":
            obj.get("nextFundingRateTime"),
            "maxLeverage":
            obj.get("maxLeverage"),
            "sourceExchanges":
            obj.get("sourceExchanges"),
            "premiumsSymbol1M":
            obj.get("premiumsSymbol1M"),
            "premiumsSymbol8H":
            obj.get("premiumsSymbol8H"),
            "fundingBaseSymbol1M":
            obj.get("fundingBaseSymbol1M"),
            "fundingQuoteSymbol1M":
            obj.get("fundingQuoteSymbol1M"),
            "lowPrice":
            obj.get("lowPrice"),
            "highPrice":
            obj.get("highPrice"),
            "priceChgPct":
            obj.get("priceChgPct"),
            "priceChg":
            obj.get("priceChg"),
            "k":
            obj.get("k"),
            "m":
            obj.get("m"),
            "f":
            obj.get("f"),
            "mmrLimit":
            obj.get("mmrLimit"),
            "mmrLevConstant":
            obj.get("mmrLevConstant"),
            "supportCross":
            obj.get("supportCross"),
            "buyLimit":
            obj.get("buyLimit"),
            "sellLimit":
            obj.get("sellLimit")
        })
        return _obj
