# coding: utf-8

# Code generated by Kucoin Universal SDK Generator; DO NOT EDIT.

from __future__ import annotations
import pprint
import json

from enum import Enum
from pydantic import BaseModel, ConfigDict, Field
from typing import Any, ClassVar, Dict, List, Optional


class GetPublicTokenInstanceServers(BaseModel):
    """
    GetPublicTokenInstanceServers

    Attributes:
        endpoint (str): Websocket domain URL. It is recommended to use a dynamic URL, as the URL may change.
        encrypt (bool): Whether to encrypt. Currently only supports wss, not ws
        protocol (ProtocolEnum): Network Protocol
        ping_interval (int): Recommended ping interval (milliseconds)
        ping_timeout (int): Heartbeat timeout (milliseconds)
    """

    class ProtocolEnum(Enum):
        """
        Attributes:
            WEBSOCKET: Websocket
        """
        WEBSOCKET = 'websocket'

    endpoint: Optional[str] = Field(
        default=None,
        description=
        "Websocket domain URL. It is recommended to use a dynamic URL, as the URL may change."
    )
    encrypt: Optional[bool] = Field(
        default=None,
        description="Whether to encrypt. Currently only supports wss, not ws")
    protocol: Optional[ProtocolEnum] = Field(default=None,
                                             description="Network Protocol")
    ping_interval: Optional[int] = Field(
        default=None,
        description="Recommended ping interval (milliseconds)",
        alias="pingInterval")
    ping_timeout: Optional[int] = Field(
        default=None,
        description="Heartbeat timeout (milliseconds)",
        alias="pingTimeout")

    __properties: ClassVar[List[str]] = [
        "endpoint", "encrypt", "protocol", "pingInterval", "pingTimeout"
    ]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=False,
        protected_namespaces=(),
    )

    def to_str(self) -> str:
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        return self.model_dump_json(by_alias=True, exclude_none=True)

    @classmethod
    def from_json(cls,
                  json_str: str) -> Optional[GetPublicTokenInstanceServers]:
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        _dict = self.model_dump(
            by_alias=True,
            exclude_none=True,
        )
        return _dict

    @classmethod
    def from_dict(
        cls,
        obj: Optional[Dict[str,
                           Any]]) -> Optional[GetPublicTokenInstanceServers]:
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "endpoint": obj.get("endpoint"),
            "encrypt": obj.get("encrypt"),
            "protocol": obj.get("protocol"),
            "pingInterval": obj.get("pingInterval"),
            "pingTimeout": obj.get("pingTimeout")
        })
        return _obj
