# coding: utf-8

# Code generated by Kucoin Universal SDK Generator; DO NOT EDIT.

from __future__ import annotations
import pprint
import json

from pydantic import BaseModel, ConfigDict, Field
from typing import Any, ClassVar, Dict, List, Optional
from .model_get_public_token_instance_servers import GetPublicTokenInstanceServers
from kucoin_universal_sdk.internal.interfaces.response import Response
from kucoin_universal_sdk.model.common import RestResponse


class GetPublicTokenResp(BaseModel, Response):
    """
    GetPublicTokenResp

    Attributes:
        token (str): The token required to establish a Websocket connection
        instance_servers (list[GetPublicTokenInstanceServers]): 
    """

    common_response: Optional[RestResponse] = Field(
        default=None, description="Common response")
    token: Optional[str] = Field(
        default=None,
        description="The token required to establish a Websocket connection")
    instance_servers: Optional[List[GetPublicTokenInstanceServers]] = Field(
        default=None, alias="instanceServers")

    __properties: ClassVar[List[str]] = ["token", "instanceServers"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=False,
        protected_namespaces=(),
    )

    def to_str(self) -> str:
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        return self.model_dump_json(by_alias=True, exclude_none=True)

    @classmethod
    def from_json(cls, json_str: str) -> Optional[GetPublicTokenResp]:
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        _dict = self.model_dump(
            by_alias=True,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of each item in instance_servers (list)
        _items = []
        if self.instance_servers:
            for _item_instance_servers in self.instance_servers:
                if _item_instance_servers:
                    _items.append(_item_instance_servers.to_dict())
            _dict['instanceServers'] = _items
        return _dict

    @classmethod
    def from_dict(
            cls, obj: Optional[Dict[str,
                                    Any]]) -> Optional[GetPublicTokenResp]:
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "token":
            obj.get("token"),
            "instanceServers": [
                GetPublicTokenInstanceServers.from_dict(_item)
                for _item in obj["instanceServers"]
            ] if obj.get("instanceServers") is not None else None
        })
        return _obj

    def set_common_response(self, response: RestResponse):
        self.common_response = response
