# coding: utf-8

# Code generated by Kucoin Universal SDK Generator; DO NOT EDIT.

from __future__ import annotations
import pprint
import json

from pydantic import BaseModel, ConfigDict, Field
from typing import Any, ClassVar, Dict, List, Optional


class GetSpotIndexPriceReq(BaseModel):
    """
    GetSpotIndexPriceReq

    Attributes:
        symbol (str): Symbol of the contract. Please refer to [Get Symbol endpoint: indexSymbol](https://www.kucoin.com/docs-new/api-3470220) 
        start_at (int): Start time (milliseconds)
        end_at (int): End time (milliseconds)
        reverse (bool): This parameter functions to judge whether the lookup is reversed. True means “yes”. False means “no”. This parameter is set as True by default.
        offset (int): Start offset. The unique attribute of the last returned result of the last request. The data of the first page will be returned by default.
        forward (bool): This parameter functions to judge whether the lookup is forward or not. True means “yes” and False means “no”. This parameter is set as true by default.
        max_count (int): Max. record count. The default record count is 10; the maximum length cannot exceed 100
    """

    symbol: Optional[str] = Field(
        default=None,
        description=
        "Symbol of the contract. Please refer to [Get Symbol endpoint: indexSymbol](https://www.kucoin.com/docs-new/api-3470220) "
    )
    start_at: Optional[int] = Field(default=None,
                                    description="Start time (milliseconds)",
                                    alias="startAt")
    end_at: Optional[int] = Field(default=None,
                                  description="End time (milliseconds)",
                                  alias="endAt")
    reverse: Optional[bool] = Field(
        default=True,
        description=
        "This parameter functions to judge whether the lookup is reversed. True means “yes”. False means “no”. This parameter is set as True by default."
    )
    offset: Optional[int] = Field(
        default=None,
        description=
        "Start offset. The unique attribute of the last returned result of the last request. The data of the first page will be returned by default."
    )
    forward: Optional[bool] = Field(
        default=True,
        description=
        "This parameter functions to judge whether the lookup is forward or not. True means “yes” and False means “no”. This parameter is set as true by default."
    )
    max_count: Optional[int] = Field(
        default=10,
        description=
        "Max. record count. The default record count is 10; the maximum length cannot exceed 100",
        alias="maxCount")

    __properties: ClassVar[List[str]] = [
        "symbol", "startAt", "endAt", "reverse", "offset", "forward",
        "maxCount"
    ]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=False,
        protected_namespaces=(),
    )

    def to_str(self) -> str:
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        return self.model_dump_json(by_alias=True, exclude_none=True)

    @classmethod
    def from_json(cls, json_str: str) -> Optional[GetSpotIndexPriceReq]:
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        _dict = self.model_dump(
            by_alias=True,
            exclude_none=True,
        )
        return _dict

    @classmethod
    def from_dict(
            cls, obj: Optional[Dict[str,
                                    Any]]) -> Optional[GetSpotIndexPriceReq]:
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "symbol":
            obj.get("symbol"),
            "startAt":
            obj.get("startAt"),
            "endAt":
            obj.get("endAt"),
            "reverse":
            obj.get("reverse") if obj.get("reverse") is not None else True,
            "offset":
            obj.get("offset"),
            "forward":
            obj.get("forward") if obj.get("forward") is not None else True,
            "maxCount":
            obj.get("maxCount") if obj.get("maxCount") is not None else 10
        })
        return _obj


class GetSpotIndexPriceReqBuilder:

    def __init__(self):
        self.obj = {}

    def set_symbol(self, value: str) -> GetSpotIndexPriceReqBuilder:
        """
        Symbol of the contract. Please refer to [Get Symbol endpoint: indexSymbol](https://www.kucoin.com/docs-new/api-3470220) 
        """
        self.obj['symbol'] = value
        return self

    def set_start_at(self, value: int) -> GetSpotIndexPriceReqBuilder:
        """
        Start time (milliseconds)
        """
        self.obj['startAt'] = value
        return self

    def set_end_at(self, value: int) -> GetSpotIndexPriceReqBuilder:
        """
        End time (milliseconds)
        """
        self.obj['endAt'] = value
        return self

    def set_reverse(self, value: bool) -> GetSpotIndexPriceReqBuilder:
        """
        This parameter functions to judge whether the lookup is reversed. True means “yes”. False means “no”. This parameter is set as True by default.
        """
        self.obj['reverse'] = value
        return self

    def set_offset(self, value: int) -> GetSpotIndexPriceReqBuilder:
        """
        Start offset. The unique attribute of the last returned result of the last request. The data of the first page will be returned by default.
        """
        self.obj['offset'] = value
        return self

    def set_forward(self, value: bool) -> GetSpotIndexPriceReqBuilder:
        """
        This parameter functions to judge whether the lookup is forward or not. True means “yes” and False means “no”. This parameter is set as true by default.
        """
        self.obj['forward'] = value
        return self

    def set_max_count(self, value: int) -> GetSpotIndexPriceReqBuilder:
        """
        Max. record count. The default record count is 10; the maximum length cannot exceed 100
        """
        self.obj['maxCount'] = value
        return self

    def build(self) -> GetSpotIndexPriceReq:
        return GetSpotIndexPriceReq(**self.obj)
