# coding: utf-8

# Code generated by Kucoin Universal SDK Generator; DO NOT EDIT.

from __future__ import annotations
import pprint
import json

from enum import Enum
from pydantic import BaseModel, ConfigDict, Field
from typing import Any, ClassVar, Dict, List, Optional
from kucoin_universal_sdk.internal.interfaces.response import Response
from kucoin_universal_sdk.model.common import RestResponse


class GetOrderByClientOidResp(BaseModel, Response):
    """
    GetOrderByClientOidResp

    Attributes:
        id (str): Order ID
        symbol (str): Symbol of the contract. Please refer to [Get Symbol endpoint: symbol](https://www.kucoin.com/docs-new/api-3470220) 
        type (TypeEnum): Order type, market order or limit order
        side (SideEnum): Transaction side
        price (str): Order Price
        size (int): Order quantity
        value (str): Order value 
        deal_value (str): Executed size of funds 
        deal_size (int): Executed quantity 
        stp (StpEnum): [Self Trade Prevention](https://www.kucoin.com/docs-new/doc-338146) is divided into these strategies: CN, CO, CB. DC not currently supported.
        stop (str): Stop order type (stop limit or stop market) 
        stop_price_type (StopPriceTypeEnum): Trigger price type of stop orders
        stop_triggered (bool): Mark to show whether the stop order is triggered
        stop_price (float): Trigger price of stop orders
        time_in_force (str): Time in force policy type 
        post_only (bool): Mark of post only 
        hidden (bool): Mark of the hidden order 
        iceberg (bool): Mark of the iceberg order 
        leverage (str): Leverage of the order 
        force_hold (bool): A mark to force-hold the funds for an order 
        close_order (bool): A mark to close the position 
        visible_size (int): Visible size of the iceberg order 
        client_oid (str): Unique order ID created by users to identify their orders 
        remark (str): Remark
        tags (str): Tag order source 
        is_active (bool): Mark of the active orders 
        cancel_exist (bool): Mark of the canceled orders 
        created_at (int): Order creation time 
        updated_at (int): Last update time 
        end_at (int): Order Endtime
        order_time (int): Order creation time in nanoseconds 
        settle_currency (str): Settlement currency 
        margin_mode (MarginModeEnum): Margin mode: ISOLATED (isolated), CROSS (cross margin). 
        avg_deal_price (str): Average transaction price, forward contract average transaction price = sum (transaction value) / sum (transaction quantity); reverse contract average transaction price = sum (transaction quantity) / sum (transaction value). Transaction quantity = lots * multiplier 
        filled_size (int): Value of the executed orders 
        filled_value (str): Executed order quantity 
        status (StatusEnum): order status: “open” or “done” 
        reduce_only (bool): A mark to reduce the position size only 
    """

    class TypeEnum(Enum):
        """
        Attributes:
            MARKET: Market Order
            LIMIT: Limit Order
        """
        MARKET = 'market'
        LIMIT = 'limit'

    class SideEnum(Enum):
        """
        Attributes:
            BUY: buy
            SELL: sell
        """
        BUY = 'buy'
        SELL = 'sell'

    class StpEnum(Enum):
        """
        Attributes:
            NULL: None
            CN: Cancel new, Cancel the new order
            CO: Cancel old, Cancel the old order
            CB: Cancel both, Cancel both sides
        """
        NULL = ''
        CN = 'CN'
        CO = 'CO'
        CB = 'CB'

    class StopPriceTypeEnum(Enum):
        """
        Attributes:
            NULL: None
            TRADE_PRICE: TP for trade price, The last trade price is the last price at which an order was filled. This price can be found in the latest match message.
            MARK_PRICE: MP for mark price. The mark price can be obtained through relevant OPEN API for index services.
            INDEX_PRICE: IP for index price. The index price can be obtained through relevant OPEN API for index services.
        """
        NULL = ''
        TRADE_PRICE = 'TP'
        MARK_PRICE = 'MP'
        INDEX_PRICE = 'IP'

    class MarginModeEnum(Enum):
        """
        Attributes:
            CROSS: Cross margin
            ISOLATED: Isolated margin
        """
        CROSS = 'CROSS'
        ISOLATED = 'ISOLATED'

    class StatusEnum(Enum):
        """
        Attributes:
            OPEN: open order
            DONE: done order
        """
        OPEN = 'open'
        DONE = 'done'

    common_response: Optional[RestResponse] = Field(
        default=None, description="Common response")
    id: Optional[str] = Field(default=None, description="Order ID")
    symbol: Optional[str] = Field(
        default=None,
        description=
        "Symbol of the contract. Please refer to [Get Symbol endpoint: symbol](https://www.kucoin.com/docs-new/api-3470220) "
    )
    type: Optional[TypeEnum] = Field(
        default=None, description="Order type, market order or limit order")
    side: Optional[SideEnum] = Field(default=None,
                                     description="Transaction side")
    price: Optional[str] = Field(default=None, description="Order Price")
    size: Optional[int] = Field(default=None, description="Order quantity")
    value: Optional[str] = Field(default=None, description="Order value ")
    deal_value: Optional[str] = Field(default=None,
                                      description="Executed size of funds ",
                                      alias="dealValue")
    deal_size: Optional[int] = Field(default=None,
                                     description="Executed quantity ",
                                     alias="dealSize")
    stp: Optional[StpEnum] = Field(
        default=None,
        description=
        "[Self Trade Prevention](https://www.kucoin.com/docs-new/doc-338146) is divided into these strategies: CN, CO, CB. DC not currently supported."
    )
    stop: Optional[str] = Field(
        default=None,
        description="Stop order type (stop limit or stop market) ")
    stop_price_type: Optional[StopPriceTypeEnum] = Field(
        default=None,
        description="Trigger price type of stop orders",
        alias="stopPriceType")
    stop_triggered: Optional[bool] = Field(
        default=None,
        description="Mark to show whether the stop order is triggered",
        alias="stopTriggered")
    stop_price: Optional[float] = Field(
        default=None,
        description="Trigger price of stop orders",
        alias="stopPrice")
    time_in_force: Optional[str] = Field(
        default=None,
        description="Time in force policy type ",
        alias="timeInForce")
    post_only: Optional[bool] = Field(default=None,
                                      description="Mark of post only ",
                                      alias="postOnly")
    hidden: Optional[bool] = Field(default=None,
                                   description="Mark of the hidden order ")
    iceberg: Optional[bool] = Field(default=None,
                                    description="Mark of the iceberg order ")
    leverage: Optional[str] = Field(default=None,
                                    description="Leverage of the order ")
    force_hold: Optional[bool] = Field(
        default=None,
        description="A mark to force-hold the funds for an order ",
        alias="forceHold")
    close_order: Optional[bool] = Field(
        default=None,
        description="A mark to close the position ",
        alias="closeOrder")
    visible_size: Optional[int] = Field(
        default=None,
        description="Visible size of the iceberg order ",
        alias="visibleSize")
    client_oid: Optional[str] = Field(
        default=None,
        description=
        "Unique order ID created by users to identify their orders ",
        alias="clientOid")
    remark: Optional[str] = Field(default=None, description="Remark")
    tags: Optional[str] = Field(default=None, description="Tag order source ")
    is_active: Optional[bool] = Field(default=None,
                                      description="Mark of the active orders ",
                                      alias="isActive")
    cancel_exist: Optional[bool] = Field(
        default=None,
        description="Mark of the canceled orders ",
        alias="cancelExist")
    created_at: Optional[int] = Field(default=None,
                                      description="Order creation time ",
                                      alias="createdAt")
    updated_at: Optional[int] = Field(default=None,
                                      description="Last update time ",
                                      alias="updatedAt")
    end_at: Optional[int] = Field(default=None,
                                  description="Order Endtime",
                                  alias="endAt")
    order_time: Optional[int] = Field(
        default=None,
        description="Order creation time in nanoseconds ",
        alias="orderTime")
    settle_currency: Optional[str] = Field(default=None,
                                           description="Settlement currency ",
                                           alias="settleCurrency")
    margin_mode: Optional[MarginModeEnum] = Field(
        default=None,
        description="Margin mode: ISOLATED (isolated), CROSS (cross margin). ",
        alias="marginMode")
    avg_deal_price: Optional[str] = Field(
        default=None,
        description=
        "Average transaction price, forward contract average transaction price = sum (transaction value) / sum (transaction quantity); reverse contract average transaction price = sum (transaction quantity) / sum (transaction value). Transaction quantity = lots * multiplier ",
        alias="avgDealPrice")
    filled_size: Optional[int] = Field(
        default=None,
        description="Value of the executed orders ",
        alias="filledSize")
    filled_value: Optional[str] = Field(default=None,
                                        description="Executed order quantity ",
                                        alias="filledValue")
    status: Optional[StatusEnum] = Field(
        default=None, description="order status: “open” or “done” ")
    reduce_only: Optional[bool] = Field(
        default=None,
        description="A mark to reduce the position size only ",
        alias="reduceOnly")

    __properties: ClassVar[List[str]] = [
        "id", "symbol", "type", "side", "price", "size", "value", "dealValue",
        "dealSize", "stp", "stop", "stopPriceType", "stopTriggered",
        "stopPrice", "timeInForce", "postOnly", "hidden", "iceberg",
        "leverage", "forceHold", "closeOrder", "visibleSize", "clientOid",
        "remark", "tags", "isActive", "cancelExist", "createdAt", "updatedAt",
        "endAt", "orderTime", "settleCurrency", "marginMode", "avgDealPrice",
        "filledSize", "filledValue", "status", "reduceOnly"
    ]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=False,
        protected_namespaces=(),
    )

    def to_str(self) -> str:
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        return self.model_dump_json(by_alias=True, exclude_none=True)

    @classmethod
    def from_json(cls, json_str: str) -> Optional[GetOrderByClientOidResp]:
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        _dict = self.model_dump(
            by_alias=True,
            exclude_none=True,
        )
        return _dict

    @classmethod
    def from_dict(
            cls,
            obj: Optional[Dict[str,
                               Any]]) -> Optional[GetOrderByClientOidResp]:
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "id": obj.get("id"),
            "symbol": obj.get("symbol"),
            "type": obj.get("type"),
            "side": obj.get("side"),
            "price": obj.get("price"),
            "size": obj.get("size"),
            "value": obj.get("value"),
            "dealValue": obj.get("dealValue"),
            "dealSize": obj.get("dealSize"),
            "stp": obj.get("stp"),
            "stop": obj.get("stop"),
            "stopPriceType": obj.get("stopPriceType"),
            "stopTriggered": obj.get("stopTriggered"),
            "stopPrice": obj.get("stopPrice"),
            "timeInForce": obj.get("timeInForce"),
            "postOnly": obj.get("postOnly"),
            "hidden": obj.get("hidden"),
            "iceberg": obj.get("iceberg"),
            "leverage": obj.get("leverage"),
            "forceHold": obj.get("forceHold"),
            "closeOrder": obj.get("closeOrder"),
            "visibleSize": obj.get("visibleSize"),
            "clientOid": obj.get("clientOid"),
            "remark": obj.get("remark"),
            "tags": obj.get("tags"),
            "isActive": obj.get("isActive"),
            "cancelExist": obj.get("cancelExist"),
            "createdAt": obj.get("createdAt"),
            "updatedAt": obj.get("updatedAt"),
            "endAt": obj.get("endAt"),
            "orderTime": obj.get("orderTime"),
            "settleCurrency": obj.get("settleCurrency"),
            "marginMode": obj.get("marginMode"),
            "avgDealPrice": obj.get("avgDealPrice"),
            "filledSize": obj.get("filledSize"),
            "filledValue": obj.get("filledValue"),
            "status": obj.get("status"),
            "reduceOnly": obj.get("reduceOnly")
        })
        return _obj

    def set_common_response(self, response: RestResponse):
        self.common_response = response
