# coding: utf-8

# Code generated by Kucoin Universal SDK Generator; DO NOT EDIT.

from __future__ import annotations
import pprint
import json

from enum import Enum
from pydantic import BaseModel, ConfigDict, Field
from typing import Any, ClassVar, Dict, List, Optional


class GetPositionsHistoryItems(BaseModel):
    """
    GetPositionsHistoryItems

    Attributes:
        close_id (str): Close ID 
        user_id (str): User ID
        symbol (str): Symbol of the contract, Please refer to [Get Symbol endpoint: symbol](https://www.kucoin.com/docs-new/api-3470220) 
        settle_currency (str): Currency used to settle trades 
        leverage (str): Leverage applied to the order 
        type (str): Type of closure 
        pnl (str): Net profit and loss (after deducting fees and funding costs) 
        realised_gross_cost (str): Accumulated realised gross profit value 
        withdraw_pnl (str): Accumulated realised profit withdrawn from the position 
        trade_fee (str): Accumulated trading fees 
        funding_fee (str): Accumulated funding fees 
        open_time (int): Time when the position was opened 
        close_time (int): Time when the position was closed (default sorted in descending order) 
        open_price (str): Opening price of the position 
        close_price (str): Closing price of the position 
        margin_mode (MarginModeEnum): Margin Mode: CROSS，ISOLATED
        realised_gross_cost_new (str): 
        tax (str): Tax
        roe (str): 
        liquid_amount (str): 
        liquid_price (str): 
        side (str): Position side
    """

    class MarginModeEnum(Enum):
        """
        Attributes:
            CROSS: cross margin
            ISOLATED: isolated margin
        """
        CROSS = 'CROSS'
        ISOLATED = 'ISOLATED'

    close_id: Optional[str] = Field(default=None,
                                    description="Close ID ",
                                    alias="closeId")
    user_id: Optional[str] = Field(default=None,
                                   description="User ID",
                                   alias="userId")
    symbol: Optional[str] = Field(
        default=None,
        description=
        "Symbol of the contract, Please refer to [Get Symbol endpoint: symbol](https://www.kucoin.com/docs-new/api-3470220) "
    )
    settle_currency: Optional[str] = Field(
        default=None,
        description="Currency used to settle trades ",
        alias="settleCurrency")
    leverage: Optional[str] = Field(
        default=None, description="Leverage applied to the order ")
    type: Optional[str] = Field(default=None, description="Type of closure ")
    pnl: Optional[str] = Field(
        default=None,
        description=
        "Net profit and loss (after deducting fees and funding costs) ")
    realised_gross_cost: Optional[str] = Field(
        default=None,
        description="Accumulated realised gross profit value ",
        alias="realisedGrossCost")
    withdraw_pnl: Optional[str] = Field(
        default=None,
        description="Accumulated realised profit withdrawn from the position ",
        alias="withdrawPnl")
    trade_fee: Optional[str] = Field(default=None,
                                     description="Accumulated trading fees ",
                                     alias="tradeFee")
    funding_fee: Optional[str] = Field(default=None,
                                       description="Accumulated funding fees ",
                                       alias="fundingFee")
    open_time: Optional[int] = Field(
        default=None,
        description="Time when the position was opened ",
        alias="openTime")
    close_time: Optional[int] = Field(
        default=None,
        description=
        "Time when the position was closed (default sorted in descending order) ",
        alias="closeTime")
    open_price: Optional[str] = Field(
        default=None,
        description="Opening price of the position ",
        alias="openPrice")
    close_price: Optional[str] = Field(
        default=None,
        description="Closing price of the position ",
        alias="closePrice")
    margin_mode: Optional[MarginModeEnum] = Field(
        default=None,
        description="Margin Mode: CROSS，ISOLATED",
        alias="marginMode")
    realised_gross_cost_new: Optional[str] = Field(
        default=None, alias="realisedGrossCostNew")
    tax: Optional[str] = Field(default=None, description="Tax")
    roe: Optional[str] = None
    liquid_amount: Optional[str] = Field(default=None, alias="liquidAmount")
    liquid_price: Optional[str] = Field(default=None, alias="liquidPrice")
    side: Optional[str] = Field(default=None, description="Position side")

    __properties: ClassVar[List[str]] = [
        "closeId", "userId", "symbol", "settleCurrency", "leverage", "type",
        "pnl", "realisedGrossCost", "withdrawPnl", "tradeFee", "fundingFee",
        "openTime", "closeTime", "openPrice", "closePrice", "marginMode",
        "realisedGrossCostNew", "tax", "roe", "liquidAmount", "liquidPrice",
        "side"
    ]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=False,
        protected_namespaces=(),
    )

    def to_str(self) -> str:
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        return self.model_dump_json(by_alias=True, exclude_none=True)

    @classmethod
    def from_json(cls, json_str: str) -> Optional[GetPositionsHistoryItems]:
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        _dict = self.model_dump(
            by_alias=True,
            exclude_none=True,
        )
        return _dict

    @classmethod
    def from_dict(
            cls,
            obj: Optional[Dict[str,
                               Any]]) -> Optional[GetPositionsHistoryItems]:
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "closeId":
            obj.get("closeId"),
            "userId":
            obj.get("userId"),
            "symbol":
            obj.get("symbol"),
            "settleCurrency":
            obj.get("settleCurrency"),
            "leverage":
            obj.get("leverage"),
            "type":
            obj.get("type"),
            "pnl":
            obj.get("pnl"),
            "realisedGrossCost":
            obj.get("realisedGrossCost"),
            "withdrawPnl":
            obj.get("withdrawPnl"),
            "tradeFee":
            obj.get("tradeFee"),
            "fundingFee":
            obj.get("fundingFee"),
            "openTime":
            obj.get("openTime"),
            "closeTime":
            obj.get("closeTime"),
            "openPrice":
            obj.get("openPrice"),
            "closePrice":
            obj.get("closePrice"),
            "marginMode":
            obj.get("marginMode"),
            "realisedGrossCostNew":
            obj.get("realisedGrossCostNew"),
            "tax":
            obj.get("tax"),
            "roe":
            obj.get("roe"),
            "liquidAmount":
            obj.get("liquidAmount"),
            "liquidPrice":
            obj.get("liquidPrice"),
            "side":
            obj.get("side")
        })
        return _obj
