# coding: utf-8

# Code generated by Kucoin Universal SDK Generator; DO NOT EDIT.

from __future__ import annotations
import pprint
import json

from enum import Enum
from pydantic import BaseModel, ConfigDict, Field
from typing import Any, ClassVar, Dict, List, Optional
from kucoin_universal_sdk.internal.interfaces.response import Response
from kucoin_universal_sdk.model.common import RestResponse


class SwitchMarginModeResp(BaseModel, Response):
    """
    SwitchMarginModeResp

    Attributes:
        symbol (str): Symbol of the contract, Please refer to [Get Symbol endpoint: symbol](https://www.kucoin.com/docs-new/api-3470220) 
        margin_mode (MarginModeEnum): Margin mode: ISOLATED (isolated), CROSS (cross margin).
    """

    class MarginModeEnum(Enum):
        """
        Attributes:
            ISOLATED: isolated margin
            CROSS: cross margin
        """
        ISOLATED = 'ISOLATED'
        CROSS = 'CROSS'

    common_response: Optional[RestResponse] = Field(
        default=None, description="Common response")
    symbol: Optional[str] = Field(
        default=None,
        description=
        "Symbol of the contract, Please refer to [Get Symbol endpoint: symbol](https://www.kucoin.com/docs-new/api-3470220) "
    )
    margin_mode: Optional[MarginModeEnum] = Field(
        default=None,
        description="Margin mode: ISOLATED (isolated), CROSS (cross margin).",
        alias="marginMode")

    __properties: ClassVar[List[str]] = ["symbol", "marginMode"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=False,
        protected_namespaces=(),
    )

    def to_str(self) -> str:
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        return self.model_dump_json(by_alias=True, exclude_none=True)

    @classmethod
    def from_json(cls, json_str: str) -> Optional[SwitchMarginModeResp]:
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        _dict = self.model_dump(
            by_alias=True,
            exclude_none=True,
        )
        return _dict

    @classmethod
    def from_dict(
            cls, obj: Optional[Dict[str,
                                    Any]]) -> Optional[SwitchMarginModeResp]:
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "symbol": obj.get("symbol"),
            "marginMode": obj.get("marginMode")
        })
        return _obj

    def set_common_response(self, response: RestResponse):
        self.common_response = response
