# coding: utf-8

# Code generated by Kucoin Universal SDK Generator; DO NOT EDIT.

from __future__ import annotations
import pprint
import json

from pydantic import BaseModel, ConfigDict, Field
from typing import Any, ClassVar, Dict, List, Optional


class GetRedeemOrdersItems(BaseModel):
    """
    GetRedeemOrdersItems

    Attributes:
        currency (str): Currency
        purchase_order_no (str): Purchase order ID
        redeem_order_no (str): Redeem order ID
        redeem_size (str): Redemption size
        receipt_size (str): Redeemed size
        apply_time (str): Time of redeem
        status (str): Status: DONE-completed; PENDING-settling
    """

    currency: Optional[str] = Field(default=None, description="Currency")
    purchase_order_no: Optional[str] = Field(default=None,
                                             description="Purchase order ID",
                                             alias="purchaseOrderNo")
    redeem_order_no: Optional[str] = Field(default=None,
                                           description="Redeem order ID",
                                           alias="redeemOrderNo")
    redeem_size: Optional[str] = Field(default=None,
                                       description="Redemption size",
                                       alias="redeemSize")
    receipt_size: Optional[str] = Field(default=None,
                                        description="Redeemed size",
                                        alias="receiptSize")
    apply_time: Optional[str] = Field(default=None,
                                      description="Time of redeem",
                                      alias="applyTime")
    status: Optional[str] = Field(
        default=None, description="Status: DONE-completed; PENDING-settling")

    __properties: ClassVar[List[str]] = [
        "currency", "purchaseOrderNo", "redeemOrderNo", "redeemSize",
        "receiptSize", "applyTime", "status"
    ]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=False,
        protected_namespaces=(),
    )

    def to_str(self) -> str:
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        return self.model_dump_json(by_alias=True, exclude_none=True)

    @classmethod
    def from_json(cls, json_str: str) -> Optional[GetRedeemOrdersItems]:
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        _dict = self.model_dump(
            by_alias=True,
            exclude_none=True,
        )
        return _dict

    @classmethod
    def from_dict(
            cls, obj: Optional[Dict[str,
                                    Any]]) -> Optional[GetRedeemOrdersItems]:
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "currency": obj.get("currency"),
            "purchaseOrderNo": obj.get("purchaseOrderNo"),
            "redeemOrderNo": obj.get("redeemOrderNo"),
            "redeemSize": obj.get("redeemSize"),
            "receiptSize": obj.get("receiptSize"),
            "applyTime": obj.get("applyTime"),
            "status": obj.get("status")
        })
        return _obj
