# coding: utf-8

# Code generated by Kucoin Universal SDK Generator; DO NOT EDIT.

from __future__ import annotations
import pprint
import json

from enum import Enum
from pydantic import BaseModel, ConfigDict, Field
from typing import Any, ClassVar, Dict, List, Optional


class GetRedeemOrdersReq(BaseModel):
    """
    GetRedeemOrdersReq

    Attributes:
        status (StatusEnum): DONE-completed; PENDING-settling
        currency (str): currency
        redeem_order_no (str): Redeem order ID
        current_page (int): Current page; default is 1
        page_size (int): Page size; 1<=pageSize<=50; default is 50
    """

    class StatusEnum(Enum):
        """
        Attributes:
            DONE: completed
            PENDING: settling
        """
        DONE = 'DONE'
        PENDING = 'PENDING'

    status: Optional[StatusEnum] = Field(
        default=None, description="DONE-completed; PENDING-settling")
    currency: Optional[str] = Field(default=None, description="currency")
    redeem_order_no: Optional[str] = Field(default=None,
                                           description="Redeem order ID",
                                           alias="redeemOrderNo")
    current_page: Optional[int] = Field(
        default=1,
        description="Current page; default is 1",
        alias="currentPage")
    page_size: Optional[int] = Field(
        default=50,
        description="Page size; 1<=pageSize<=50; default is 50",
        alias="pageSize")

    __properties: ClassVar[List[str]] = [
        "status", "currency", "redeemOrderNo", "currentPage", "pageSize"
    ]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=False,
        protected_namespaces=(),
    )

    def to_str(self) -> str:
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        return self.model_dump_json(by_alias=True, exclude_none=True)

    @classmethod
    def from_json(cls, json_str: str) -> Optional[GetRedeemOrdersReq]:
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        _dict = self.model_dump(
            by_alias=True,
            exclude_none=True,
        )
        return _dict

    @classmethod
    def from_dict(
            cls, obj: Optional[Dict[str,
                                    Any]]) -> Optional[GetRedeemOrdersReq]:
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "status":
            obj.get("status"),
            "currency":
            obj.get("currency"),
            "redeemOrderNo":
            obj.get("redeemOrderNo"),
            "currentPage":
            obj.get("currentPage")
            if obj.get("currentPage") is not None else 1,
            "pageSize":
            obj.get("pageSize") if obj.get("pageSize") is not None else 50
        })
        return _obj


class GetRedeemOrdersReqBuilder:

    def __init__(self):
        self.obj = {}

    def set_status(
            self,
            value: GetRedeemOrdersReq.StatusEnum) -> GetRedeemOrdersReqBuilder:
        """
        DONE-completed; PENDING-settling
        """
        self.obj['status'] = value
        return self

    def set_currency(self, value: str) -> GetRedeemOrdersReqBuilder:
        """
        currency
        """
        self.obj['currency'] = value
        return self

    def set_redeem_order_no(self, value: str) -> GetRedeemOrdersReqBuilder:
        """
        Redeem order ID
        """
        self.obj['redeemOrderNo'] = value
        return self

    def set_current_page(self, value: int) -> GetRedeemOrdersReqBuilder:
        """
        Current page; default is 1
        """
        self.obj['currentPage'] = value
        return self

    def set_page_size(self, value: int) -> GetRedeemOrdersReqBuilder:
        """
        Page size; 1<=pageSize<=50; default is 50
        """
        self.obj['pageSize'] = value
        return self

    def build(self) -> GetRedeemOrdersReq:
        return GetRedeemOrdersReq(**self.obj)
