# coding: utf-8

# Code generated by Kucoin Universal SDK Generator; DO NOT EDIT.

from __future__ import annotations
import pprint
import json

from pydantic import BaseModel, ConfigDict, Field
from typing import Any, ClassVar, Dict, List, Optional


class ModifyPurchaseReq(BaseModel):
    """
    ModifyPurchaseReq

    Attributes:
        currency (str): Currency
        interest_rate (str): Modified purchase interest rate
        purchase_order_no (str): Purchase order ID
    """

    currency: Optional[str] = Field(default=None, description="Currency")
    interest_rate: Optional[str] = Field(
        default=None,
        description="Modified purchase interest rate",
        alias="interestRate")
    purchase_order_no: Optional[str] = Field(default=None,
                                             description="Purchase order ID",
                                             alias="purchaseOrderNo")

    __properties: ClassVar[List[str]] = [
        "currency", "interestRate", "purchaseOrderNo"
    ]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=False,
        protected_namespaces=(),
    )

    def to_str(self) -> str:
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        return self.model_dump_json(by_alias=True, exclude_none=True)

    @classmethod
    def from_json(cls, json_str: str) -> Optional[ModifyPurchaseReq]:
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        _dict = self.model_dump(
            by_alias=True,
            exclude_none=True,
        )
        return _dict

    @classmethod
    def from_dict(
            cls, obj: Optional[Dict[str, Any]]) -> Optional[ModifyPurchaseReq]:
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "currency": obj.get("currency"),
            "interestRate": obj.get("interestRate"),
            "purchaseOrderNo": obj.get("purchaseOrderNo")
        })
        return _obj


class ModifyPurchaseReqBuilder:

    def __init__(self):
        self.obj = {}

    def set_currency(self, value: str) -> ModifyPurchaseReqBuilder:
        """
        Currency
        """
        self.obj['currency'] = value
        return self

    def set_interest_rate(self, value: str) -> ModifyPurchaseReqBuilder:
        """
        Modified purchase interest rate
        """
        self.obj['interestRate'] = value
        return self

    def set_purchase_order_no(self, value: str) -> ModifyPurchaseReqBuilder:
        """
        Purchase order ID
        """
        self.obj['purchaseOrderNo'] = value
        return self

    def build(self) -> ModifyPurchaseReq:
        return ModifyPurchaseReq(**self.obj)
