# Code generated by Kucoin Universal SDK Generator; DO NOT EDIT.

from abc import ABC, abstractmethod
from typing import Any
from kucoin_universal_sdk.internal.interfaces.transport import Transport
from .model_borrow_req import BorrowReq
from .model_borrow_resp import BorrowResp
from .model_get_borrow_history_req import GetBorrowHistoryReq
from .model_get_borrow_history_resp import GetBorrowHistoryResp
from .model_get_interest_history_req import GetInterestHistoryReq
from .model_get_interest_history_resp import GetInterestHistoryResp
from .model_get_repay_history_req import GetRepayHistoryReq
from .model_get_repay_history_resp import GetRepayHistoryResp
from .model_modify_leverage_req import ModifyLeverageReq
from .model_modify_leverage_resp import ModifyLeverageResp
from .model_repay_req import RepayReq
from .model_repay_resp import RepayResp


class DebitAPI(ABC):

    @abstractmethod
    def borrow(self, req: BorrowReq, **kwargs: Any) -> BorrowResp:
        """
        summary: Borrow
        description: This API endpoint is used to initiate an application for cross or isolated margin borrowing.
        documentation: https://www.kucoin.com/docs-new/api-3470206
        +-----------------------+---------+
        | Extra API Info        | Value   |
        +-----------------------+---------+
        | API-DOMAIN            | SPOT    |
        | API-CHANNEL           | PRIVATE |
        | API-PERMISSION        | MARGIN  |
        | API-RATE-LIMIT-POOL   | SPOT    |
        | API-RATE-LIMIT-WEIGHT | 15      |
        +-----------------------+---------+
        """
        pass

    @abstractmethod
    def get_borrow_history(self, req: GetBorrowHistoryReq,
                           **kwargs: Any) -> GetBorrowHistoryResp:
        """
        summary: Get Borrow History
        description: This API endpoint is used to get the borrowing orders for cross and isolated margin accounts.
        documentation: https://www.kucoin.com/docs-new/api-3470207
        +-----------------------+---------+
        | Extra API Info        | Value   |
        +-----------------------+---------+
        | API-DOMAIN            | SPOT    |
        | API-CHANNEL           | PRIVATE |
        | API-PERMISSION        | MARGIN  |
        | API-RATE-LIMIT-POOL   | SPOT    |
        | API-RATE-LIMIT-WEIGHT | 15      |
        +-----------------------+---------+
        """
        pass

    @abstractmethod
    def repay(self, req: RepayReq, **kwargs: Any) -> RepayResp:
        """
        summary: Repay
        description: This API endpoint is used to initiate an application for cross or isolated margin repayment.
        documentation: https://www.kucoin.com/docs-new/api-3470210
        +-----------------------+---------+
        | Extra API Info        | Value   |
        +-----------------------+---------+
        | API-DOMAIN            | SPOT    |
        | API-CHANNEL           | PRIVATE |
        | API-PERMISSION        | MARGIN  |
        | API-RATE-LIMIT-POOL   | SPOT    |
        | API-RATE-LIMIT-WEIGHT | 10      |
        +-----------------------+---------+
        """
        pass

    @abstractmethod
    def get_repay_history(self, req: GetRepayHistoryReq,
                          **kwargs: Any) -> GetRepayHistoryResp:
        """
        summary: Get Repay History
        description: This API endpoint is used to get the borrowing orders for cross and isolated margin accounts.
        documentation: https://www.kucoin.com/docs-new/api-3470208
        +-----------------------+---------+
        | Extra API Info        | Value   |
        +-----------------------+---------+
        | API-DOMAIN            | SPOT    |
        | API-CHANNEL           | PRIVATE |
        | API-PERMISSION        | MARGIN  |
        | API-RATE-LIMIT-POOL   | SPOT    |
        | API-RATE-LIMIT-WEIGHT | 15      |
        +-----------------------+---------+
        """
        pass

    @abstractmethod
    def get_interest_history(self, req: GetInterestHistoryReq,
                             **kwargs: Any) -> GetInterestHistoryResp:
        """
        summary: Get Interest History.
        description: Request the interest records of the cross/isolated margin lending via this endpoint.
        documentation: https://www.kucoin.com/docs-new/api-3470209
        +-----------------------+---------+
        | Extra API Info        | Value   |
        +-----------------------+---------+
        | API-DOMAIN            | SPOT    |
        | API-CHANNEL           | PRIVATE |
        | API-PERMISSION        | MARGIN  |
        | API-RATE-LIMIT-POOL   | SPOT    |
        | API-RATE-LIMIT-WEIGHT | 20      |
        +-----------------------+---------+
        """
        pass

    @abstractmethod
    def modify_leverage(self, req: ModifyLeverageReq,
                        **kwargs: Any) -> ModifyLeverageResp:
        """
        summary: Modify Leverage
        description: This endpoint allows modifying the leverage multiplier for cross margin or isolated margin.
        documentation: https://www.kucoin.com/docs-new/api-3470211
        +-----------------------+---------+
        | Extra API Info        | Value   |
        +-----------------------+---------+
        | API-DOMAIN            | SPOT    |
        | API-CHANNEL           | PRIVATE |
        | API-PERMISSION        | MARGIN  |
        | API-RATE-LIMIT-POOL   | SPOT    |
        | API-RATE-LIMIT-WEIGHT | 8       |
        +-----------------------+---------+
        """
        pass


class DebitAPIImpl(DebitAPI):

    def __init__(self, transport: Transport):
        self.transport = transport

    def borrow(self, req: BorrowReq, **kwargs: Any) -> BorrowResp:
        return self.transport.call("spot", False,
                                   "POST", "/api/v3/margin/borrow", req,
                                   BorrowResp(), False, **kwargs)

    def get_borrow_history(self, req: GetBorrowHistoryReq,
                           **kwargs: Any) -> GetBorrowHistoryResp:
        return self.transport.call("spot", False, "GET",
                                   "/api/v3/margin/borrow", req,
                                   GetBorrowHistoryResp(), False, **kwargs)

    def repay(self, req: RepayReq, **kwargs: Any) -> RepayResp:
        return self.transport.call("spot", False,
                                   "POST", "/api/v3/margin/repay", req,
                                   RepayResp(), False, **kwargs)

    def get_repay_history(self, req: GetRepayHistoryReq,
                          **kwargs: Any) -> GetRepayHistoryResp:
        return self.transport.call("spot", False, "GET",
                                   "/api/v3/margin/repay", req,
                                   GetRepayHistoryResp(), False, **kwargs)

    def get_interest_history(self, req: GetInterestHistoryReq,
                             **kwargs: Any) -> GetInterestHistoryResp:
        return self.transport.call("spot", False, "GET",
                                   "/api/v3/margin/interest", req,
                                   GetInterestHistoryResp(), False, **kwargs)

    def modify_leverage(self, req: ModifyLeverageReq,
                        **kwargs: Any) -> ModifyLeverageResp:
        return self.transport.call("spot", False, "POST",
                                   "/api/v3/position/update-user-leverage",
                                   req, ModifyLeverageResp(), False, **kwargs)
