# coding: utf-8

# Code generated by Kucoin Universal SDK Generator; DO NOT EDIT.

from __future__ import annotations
import pprint
import json

from enum import Enum
from pydantic import BaseModel, ConfigDict, Field
from typing import Any, ClassVar, Dict, List, Optional


class GetBorrowHistoryItems(BaseModel):
    """
    GetBorrowHistoryItems

    Attributes:
        order_no (str): Borrow Order ID
        symbol (str): Isolated Margin symbol; empty for cross margin
        currency (str): currency
        size (str): Initiated borrow amount
        actual_size (str): Actual borrow amount
        status (StatusEnum): PENDING: Processing, SUCCESS: Successful, FAILED: Failed
        created_time (int): Borrow time
    """

    class StatusEnum(Enum):
        """
        Attributes:
            PENDING: 
            SUCCESS: 
            FAILED: 
        """
        PENDING = 'PENDING'
        SUCCESS = 'SUCCESS'
        FAILED = 'FAILED'

    order_no: Optional[str] = Field(default=None,
                                    description="Borrow Order ID",
                                    alias="orderNo")
    symbol: Optional[str] = Field(
        default=None,
        description="Isolated Margin symbol; empty for cross margin")
    currency: Optional[str] = Field(default=None, description="currency")
    size: Optional[str] = Field(default=None,
                                description="Initiated borrow amount")
    actual_size: Optional[str] = Field(default=None,
                                       description="Actual borrow amount",
                                       alias="actualSize")
    status: Optional[StatusEnum] = Field(
        default=None,
        description="PENDING: Processing, SUCCESS: Successful, FAILED: Failed")
    created_time: Optional[int] = Field(default=None,
                                        description="Borrow time",
                                        alias="createdTime")

    __properties: ClassVar[List[str]] = [
        "orderNo", "symbol", "currency", "size", "actualSize", "status",
        "createdTime"
    ]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=False,
        protected_namespaces=(),
    )

    def to_str(self) -> str:
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        return self.model_dump_json(by_alias=True, exclude_none=True)

    @classmethod
    def from_json(cls, json_str: str) -> Optional[GetBorrowHistoryItems]:
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        _dict = self.model_dump(
            by_alias=True,
            exclude_none=True,
        )
        return _dict

    @classmethod
    def from_dict(
            cls, obj: Optional[Dict[str,
                                    Any]]) -> Optional[GetBorrowHistoryItems]:
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "orderNo": obj.get("orderNo"),
            "symbol": obj.get("symbol"),
            "currency": obj.get("currency"),
            "size": obj.get("size"),
            "actualSize": obj.get("actualSize"),
            "status": obj.get("status"),
            "createdTime": obj.get("createdTime")
        })
        return _obj
