# coding: utf-8

# Code generated by Kucoin Universal SDK Generator; DO NOT EDIT.

from __future__ import annotations
import pprint
import json

from enum import Enum
from pydantic import BaseModel, ConfigDict, Field
from typing import Any, Callable, ClassVar, Dict, List, Optional
from .model_cross_margin_position_asset_list_value import CrossMarginPositionAssetListValue
from kucoin_universal_sdk.internal.interfaces.websocket import WebSocketMessageCallback
from kucoin_universal_sdk.model.common import WsMessage


class CrossMarginPositionEvent(BaseModel):
    """
    CrossMarginPositionEvent

    Attributes:
        debt_ratio (float): Debt ratio
        total_asset (float): Total assets in BTC (interest included)
        margin_coefficient_total_asset (str): 
        total_debt (str): Total debt in BTC (interest included)
        asset_list (dict[str, CrossMarginPositionAssetListValue]): Asset list (interest included)
        debt_list (dict[str, str]): Debt list (interest included)
        timestamp (int): 
        type (TypeEnum): Event type, **Only applicable to \"debt.ratio\" subject**
    """

    class TypeEnum(Enum):
        """
        Attributes:
            FROZEN_FL: When the debt ratio exceeds the liquidation threshold and the position is frozen, the system will push this event.
            UNFROZEN_FL: When the liquidation is finished and the position returns to “EFFECTIVE” status, the system will push this event.
            FROZEN_RENEW: When the auto-borrow renewing is complete and the position returns to “EFFECTIVE” status, the system will push this event.
            UNFROZEN_RENEW: When the account reaches a negative balance, the system will push this event.
            LIABILITY: When the account reaches a negative balance, the system will push this event.
            UNLIABILITY: When all the liabilities are repaid and the position returns to “EFFECTIVE” status, the system will push this event.
        """
        FROZEN_FL = 'FROZEN_FL'
        UNFROZEN_FL = 'UNFROZEN_FL'
        FROZEN_RENEW = 'FROZEN_RENEW'
        UNFROZEN_RENEW = 'UNFROZEN_RENEW'
        LIABILITY = 'LIABILITY'
        UNLIABILITY = 'UNLIABILITY'

    common_response: Optional[WsMessage] = Field(default=None,
                                                 description="Common response")
    debt_ratio: Optional[float] = Field(default=None,
                                        description="Debt ratio",
                                        alias="debtRatio")
    total_asset: Optional[float] = Field(
        default=None,
        description="Total assets in BTC (interest included)",
        alias="totalAsset")
    margin_coefficient_total_asset: Optional[str] = Field(
        default=None, alias="marginCoefficientTotalAsset")
    total_debt: Optional[str] = Field(
        default=None,
        description="Total debt in BTC (interest included)",
        alias="totalDebt")
    asset_list: Optional[Dict[str, CrossMarginPositionAssetListValue]] = Field(
        default=None,
        description="Asset list (interest included)",
        alias="assetList")
    debt_list: Optional[Dict[str, str]] = Field(
        default=None,
        description="Debt list (interest included)",
        alias="debtList")
    timestamp: Optional[int] = None
    type: Optional[TypeEnum] = Field(
        default=None,
        description="Event type, **Only applicable to \"debt.ratio\" subject**"
    )

    __properties: ClassVar[List[str]] = [
        "debtRatio", "totalAsset", "marginCoefficientTotalAsset", "totalDebt",
        "assetList", "debtList", "timestamp", "type"
    ]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=False,
        protected_namespaces=(),
    )

    def to_str(self) -> str:
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        return self.model_dump_json(by_alias=True, exclude_none=True)

    @classmethod
    def from_json(cls, json_str: str) -> Optional[CrossMarginPositionEvent]:
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        _dict = self.model_dump(
            by_alias=True,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of each value in asset_list (dict)
        _field_dict = {}
        if self.asset_list:
            for _key_asset_list in self.asset_list:
                if self.asset_list[_key_asset_list]:
                    _field_dict[_key_asset_list] = self.asset_list[
                        _key_asset_list].to_dict()
            _dict['assetList'] = _field_dict
        return _dict

    @classmethod
    def from_dict(
            cls,
            obj: Optional[Dict[str,
                               Any]]) -> Optional[CrossMarginPositionEvent]:
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "debtRatio":
            obj.get("debtRatio"),
            "totalAsset":
            obj.get("totalAsset"),
            "marginCoefficientTotalAsset":
            obj.get("marginCoefficientTotalAsset"),
            "totalDebt":
            obj.get("totalDebt"),
            "assetList":
            dict((_k, CrossMarginPositionAssetListValue.from_dict(_v))
                 for _k, _v in obj["assetList"].items())
            if obj.get("assetList") is not None else None,
            "debtList":
            obj.get("debtList"),
            "timestamp":
            obj.get("timestamp"),
            "type":
            obj.get("type")
        })
        return _obj


CrossMarginPositionEventCallback = Callable[
    [str, str, CrossMarginPositionEvent], None]
"""
args:
    - topic (str) : topic
    - subject (str): subject
    - data (CrossMarginPositionEvent): event data
"""


class CrossMarginPositionEventCallbackWrapper(WebSocketMessageCallback):

    def __init__(self, cb: CrossMarginPositionEventCallback):
        self.callback = cb

    def on_message(self, message: WsMessage):
        event = CrossMarginPositionEvent.from_dict(message.raw_data)
        event.common_response = message
        self.callback(message.topic, message.subject, event)
