# Code generated by Kucoin Universal SDK Generator; DO NOT EDIT.

from abc import ABC, abstractmethod
from kucoin_universal_sdk.internal.interfaces.websocket import WebSocketService
from .model_cross_margin_position_event import CrossMarginPositionEventCallback, CrossMarginPositionEventCallbackWrapper
from .model_isolated_margin_position_event import IsolatedMarginPositionEventCallback, IsolatedMarginPositionEventCallbackWrapper


class MarginPrivateWS(ABC):

    @abstractmethod
    def cross_margin_position(
            self, callback: CrossMarginPositionEventCallback) -> str:
        """
        summary: Get Cross Margin Position change
        description: The system will push the change event when the position status changes, or push the current debt message periodically when there is a liability.
        push frequency: once every 4s
        """
        pass

    @abstractmethod
    def isolated_margin_position(
            self, symbol: str,
            callback: IsolatedMarginPositionEventCallback) -> str:
        """
        summary: Get Isolated Margin Position change
        description: The system will push the change event when the position status changes, or push the current debt message periodically when there is a liability.
        push frequency: real time
        """
        pass

    @abstractmethod
    def unsubscribe(self, id: str):
        pass

    @abstractmethod
    def start(self):
        pass

    @abstractmethod
    def stop(self):
        pass


class MarginPrivateWSImpl(MarginPrivateWS):

    def __init__(self, transport: WebSocketService):
        self.transport = transport

    def cross_margin_position(
            self, callback: CrossMarginPositionEventCallback) -> str:
        topic_prefix = "/margin/position"

        args = []

        return self.transport.subscribe(
            topic_prefix, args,
            CrossMarginPositionEventCallbackWrapper(callback))

    def isolated_margin_position(
            self, symbol: str,
            callback: IsolatedMarginPositionEventCallback) -> str:
        topic_prefix = "/margin/isolatedPosition"

        args = [symbol]

        return self.transport.subscribe(
            topic_prefix, args,
            IsolatedMarginPositionEventCallbackWrapper(callback))

    def unsubscribe(self, id: str):
        self.transport.unsubscribe(id)

    def start(self):
        self.transport.start()

    def stop(self):
        self.transport.stop()
