# coding: utf-8

# Code generated by Kucoin Universal SDK Generator; DO NOT EDIT.

from __future__ import annotations
import pprint
import json

from pydantic import BaseModel, ConfigDict, Field
from typing import Any, ClassVar, Dict, List, Optional


class GetEtfInfoData(BaseModel):
    """
    GetEtfInfoData

    Attributes:
        currency (str): ETF Currency
        net_asset (str): Net worth
        target_leverage (str): Target leverage
        actual_leverage (str): Actual leverage
        issued_size (str): The amount of currency issued
        basket (str): Basket information
    """

    currency: Optional[str] = Field(default=None, description="ETF Currency")
    net_asset: Optional[str] = Field(default=None,
                                     description="Net worth",
                                     alias="netAsset")
    target_leverage: Optional[str] = Field(default=None,
                                           description="Target leverage",
                                           alias="targetLeverage")
    actual_leverage: Optional[str] = Field(default=None,
                                           description="Actual leverage",
                                           alias="actualLeverage")
    issued_size: Optional[str] = Field(
        default=None,
        description="The amount of currency issued",
        alias="issuedSize")
    basket: Optional[str] = Field(default=None,
                                  description="Basket information")

    __properties: ClassVar[List[str]] = [
        "currency", "netAsset", "targetLeverage", "actualLeverage",
        "issuedSize", "basket"
    ]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=False,
        protected_namespaces=(),
    )

    def to_str(self) -> str:
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        return self.model_dump_json(by_alias=True, exclude_none=True)

    @classmethod
    def from_json(cls, json_str: str) -> Optional[GetEtfInfoData]:
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        _dict = self.model_dump(
            by_alias=True,
            exclude_none=True,
        )
        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str,
                                          Any]]) -> Optional[GetEtfInfoData]:
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "currency": obj.get("currency"),
            "netAsset": obj.get("netAsset"),
            "targetLeverage": obj.get("targetLeverage"),
            "actualLeverage": obj.get("actualLeverage"),
            "issuedSize": obj.get("issuedSize"),
            "basket": obj.get("basket")
        })
        return _obj
