# coding: utf-8

# Code generated by Kucoin Universal SDK Generator; DO NOT EDIT.

from __future__ import annotations
import pprint
import json

from pydantic import BaseModel, ConfigDict, Field
from typing import Any, ClassVar, Dict, List, Optional
from kucoin_universal_sdk.internal.interfaces.response import Response
from kucoin_universal_sdk.model.common import RestResponse


class GetMarginConfigResp(BaseModel, Response):
    """
    GetMarginConfigResp

    Attributes:
        currency_list (list[str]): Available currencies for margin trade
        max_leverage (int): Max. leverage available
        warning_debt_ratio (str): The warning debt ratio of the forced liquidation
        liq_debt_ratio (str): The debt ratio of the forced liquidation
    """

    common_response: Optional[RestResponse] = Field(
        default=None, description="Common response")
    currency_list: Optional[List[str]] = Field(
        default=None,
        description="Available currencies for margin trade",
        alias="currencyList")
    max_leverage: Optional[int] = Field(default=None,
                                        description="Max. leverage available",
                                        alias="maxLeverage")
    warning_debt_ratio: Optional[str] = Field(
        default=None,
        description="The warning debt ratio of the forced liquidation",
        alias="warningDebtRatio")
    liq_debt_ratio: Optional[str] = Field(
        default=None,
        description="The debt ratio of the forced liquidation",
        alias="liqDebtRatio")

    __properties: ClassVar[List[str]] = [
        "currencyList", "maxLeverage", "warningDebtRatio", "liqDebtRatio"
    ]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=False,
        protected_namespaces=(),
    )

    def to_str(self) -> str:
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        return self.model_dump_json(by_alias=True, exclude_none=True)

    @classmethod
    def from_json(cls, json_str: str) -> Optional[GetMarginConfigResp]:
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        _dict = self.model_dump(
            by_alias=True,
            exclude_none=True,
        )
        return _dict

    @classmethod
    def from_dict(
            cls, obj: Optional[Dict[str,
                                    Any]]) -> Optional[GetMarginConfigResp]:
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "currencyList":
            obj.get("currencyList"),
            "maxLeverage":
            obj.get("maxLeverage"),
            "warningDebtRatio":
            obj.get("warningDebtRatio"),
            "liqDebtRatio":
            obj.get("liqDebtRatio")
        })
        return _obj

    def set_common_response(self, response: RestResponse):
        self.common_response = response
