# coding: utf-8

# Code generated by Kucoin Universal SDK Generator; DO NOT EDIT.

from __future__ import annotations
import pprint
import json

from pydantic import BaseModel, ConfigDict, Field
from typing import Any, ClassVar, Dict, List, Optional
from .model_get_all_currencies_data_chains import GetAllCurrenciesDataChains


class GetAllCurrenciesData(BaseModel):
    """
    GetAllCurrenciesData

    Attributes:
        currency (str): A unique currency code that will never change
        name (str): Currency name; will change after renaming
        full_name (str): Full currency name; will change after renaming
        precision (int): Currency precision
        confirms (int): Number of block confirmations
        contract_address (str): Contract address
        is_margin_enabled (bool): Margin support or not
        is_debit_enabled (bool): Debit support or not
        chains (list[GetAllCurrenciesDataChains]): Chain list
    """

    currency: Optional[str] = Field(
        default=None,
        description="A unique currency code that will never change")
    name: Optional[str] = Field(
        default=None, description="Currency name; will change after renaming")
    full_name: Optional[str] = Field(
        default=None,
        description="Full currency name; will change after renaming",
        alias="fullName")
    precision: Optional[int] = Field(default=None,
                                     description="Currency precision")
    confirms: Optional[int] = Field(
        default=None, description="Number of block confirmations")
    contract_address: Optional[str] = Field(default=None,
                                            description="Contract address",
                                            alias="contractAddress")
    is_margin_enabled: Optional[bool] = Field(
        default=None,
        description="Margin support or not",
        alias="isMarginEnabled")
    is_debit_enabled: Optional[bool] = Field(
        default=None,
        description="Debit support or not",
        alias="isDebitEnabled")
    chains: Optional[List[GetAllCurrenciesDataChains]] = Field(
        default=None, description="Chain list")

    __properties: ClassVar[List[str]] = [
        "currency", "name", "fullName", "precision", "confirms",
        "contractAddress", "isMarginEnabled", "isDebitEnabled", "chains"
    ]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=False,
        protected_namespaces=(),
    )

    def to_str(self) -> str:
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        return self.model_dump_json(by_alias=True, exclude_none=True)

    @classmethod
    def from_json(cls, json_str: str) -> Optional[GetAllCurrenciesData]:
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        _dict = self.model_dump(
            by_alias=True,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of each item in chains (list)
        _items = []
        if self.chains:
            for _item_chains in self.chains:
                if _item_chains:
                    _items.append(_item_chains.to_dict())
            _dict['chains'] = _items
        return _dict

    @classmethod
    def from_dict(
            cls, obj: Optional[Dict[str,
                                    Any]]) -> Optional[GetAllCurrenciesData]:
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "currency":
            obj.get("currency"),
            "name":
            obj.get("name"),
            "fullName":
            obj.get("fullName"),
            "precision":
            obj.get("precision"),
            "confirms":
            obj.get("confirms"),
            "contractAddress":
            obj.get("contractAddress"),
            "isMarginEnabled":
            obj.get("isMarginEnabled"),
            "isDebitEnabled":
            obj.get("isDebitEnabled"),
            "chains": [
                GetAllCurrenciesDataChains.from_dict(_item)
                for _item in obj["chains"]
            ] if obj.get("chains") is not None else None
        })
        return _obj
