# coding: utf-8

# Code generated by Kucoin Universal SDK Generator; DO NOT EDIT.

from __future__ import annotations
import pprint
import json

from enum import Enum
from pydantic import BaseModel, ConfigDict, Field
from typing import Any, ClassVar, Dict, List, Optional


class GetAllTickersTicker(BaseModel):
    """
    GetAllTickersTicker

    Attributes:
        symbol (str): Symbol
        symbol_name (str): Name of trading pairs, it will change after renaming
        buy (str): Best bid price
        best_bid_size (str): Best bid size
        sell (str): Best ask price
        best_ask_size (str): Best ask size
        change_rate (str): 24h change rate
        change_price (str): 24h change price
        high (str): Highest price in 24h
        low (str): Lowest price in 24h
        vol (str): 24h volume, executed based on base currency
        vol_value (str): 24h traded amount
        last (str): Last traded price
        average_price (str): Average trading price in the last 24 hours
        taker_fee_rate (str): Basic Taker Fee
        maker_fee_rate (str): Basic Maker Fee
        taker_coefficient (TakerCoefficientEnum): The taker fee coefficient. The actual fee needs to be multiplied by this coefficient to get the final fee. Most currencies have a coefficient of 1. If set to 0, it means no fee
        maker_coefficient (MakerCoefficientEnum): The maker fee coefficient. The actual fee needs to be multiplied by this coefficient to get the final fee. Most currencies have a coefficient of 1. If set to 0, it means no fee
    """

    class TakerCoefficientEnum(Enum):
        """
        Attributes:
            T_1: The taker fee coefficient is 1
            T_0: No fee
        """
        T_1 = '1'
        T_0 = '0'

    class MakerCoefficientEnum(Enum):
        """
        Attributes:
            T_1: The maker fee coefficient is 1
            T_0: No fee
        """
        T_1 = '1'
        T_0 = '0'

    symbol: Optional[str] = Field(default=None, description="Symbol")
    symbol_name: Optional[str] = Field(
        default=None,
        description="Name of trading pairs, it will change after renaming",
        alias="symbolName")
    buy: Optional[str] = Field(default=None, description="Best bid price")
    best_bid_size: Optional[str] = Field(default=None,
                                         description="Best bid size",
                                         alias="bestBidSize")
    sell: Optional[str] = Field(default=None, description="Best ask price")
    best_ask_size: Optional[str] = Field(default=None,
                                         description="Best ask size",
                                         alias="bestAskSize")
    change_rate: Optional[str] = Field(default=None,
                                       description="24h change rate",
                                       alias="changeRate")
    change_price: Optional[str] = Field(default=None,
                                        description="24h change price",
                                        alias="changePrice")
    high: Optional[str] = Field(default=None,
                                description="Highest price in 24h")
    low: Optional[str] = Field(default=None, description="Lowest price in 24h")
    vol: Optional[str] = Field(
        default=None,
        description="24h volume, executed based on base currency")
    vol_value: Optional[str] = Field(default=None,
                                     description="24h traded amount",
                                     alias="volValue")
    last: Optional[str] = Field(default=None, description="Last traded price")
    average_price: Optional[str] = Field(
        default=None,
        description="Average trading price in the last 24 hours",
        alias="averagePrice")
    taker_fee_rate: Optional[str] = Field(default=None,
                                          description="Basic Taker Fee",
                                          alias="takerFeeRate")
    maker_fee_rate: Optional[str] = Field(default=None,
                                          description="Basic Maker Fee",
                                          alias="makerFeeRate")
    taker_coefficient: Optional[TakerCoefficientEnum] = Field(
        default=None,
        description=
        "The taker fee coefficient. The actual fee needs to be multiplied by this coefficient to get the final fee. Most currencies have a coefficient of 1. If set to 0, it means no fee",
        alias="takerCoefficient")
    maker_coefficient: Optional[MakerCoefficientEnum] = Field(
        default=None,
        description=
        "The maker fee coefficient. The actual fee needs to be multiplied by this coefficient to get the final fee. Most currencies have a coefficient of 1. If set to 0, it means no fee",
        alias="makerCoefficient")

    __properties: ClassVar[List[str]] = [
        "symbol", "symbolName", "buy", "bestBidSize", "sell", "bestAskSize",
        "changeRate", "changePrice", "high", "low", "vol", "volValue", "last",
        "averagePrice", "takerFeeRate", "makerFeeRate", "takerCoefficient",
        "makerCoefficient"
    ]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=False,
        protected_namespaces=(),
    )

    def to_str(self) -> str:
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        return self.model_dump_json(by_alias=True, exclude_none=True)

    @classmethod
    def from_json(cls, json_str: str) -> Optional[GetAllTickersTicker]:
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        _dict = self.model_dump(
            by_alias=True,
            exclude_none=True,
        )
        return _dict

    @classmethod
    def from_dict(
            cls, obj: Optional[Dict[str,
                                    Any]]) -> Optional[GetAllTickersTicker]:
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "symbol":
            obj.get("symbol"),
            "symbolName":
            obj.get("symbolName"),
            "buy":
            obj.get("buy"),
            "bestBidSize":
            obj.get("bestBidSize"),
            "sell":
            obj.get("sell"),
            "bestAskSize":
            obj.get("bestAskSize"),
            "changeRate":
            obj.get("changeRate"),
            "changePrice":
            obj.get("changePrice"),
            "high":
            obj.get("high"),
            "low":
            obj.get("low"),
            "vol":
            obj.get("vol"),
            "volValue":
            obj.get("volValue"),
            "last":
            obj.get("last"),
            "averagePrice":
            obj.get("averagePrice"),
            "takerFeeRate":
            obj.get("takerFeeRate"),
            "makerFeeRate":
            obj.get("makerFeeRate"),
            "takerCoefficient":
            obj.get("takerCoefficient"),
            "makerCoefficient":
            obj.get("makerCoefficient")
        })
        return _obj
