# coding: utf-8

# Code generated by Kucoin Universal SDK Generator; DO NOT EDIT.

from __future__ import annotations
import pprint
import json

from enum import Enum
from pydantic import BaseModel, ConfigDict, Field
from typing import Any, ClassVar, Dict, List, Optional


class GetKlinesReq(BaseModel):
    """
    GetKlinesReq

    Attributes:
        symbol (str):  symbol
        type (TypeEnum): Type of candlestick patterns: 1min, 3min, 5min, 15min, 30min, 1hour, 2hour, 4hour, 6hour, 8hour, 12hour, 1day, 1week, 1month
        start_at (int): Start time (second), default is 0
        end_at (int): End time (second), default is 0
    """

    class TypeEnum(Enum):
        """
        Attributes:
            T_1MIN: 1min
            T_3MIN: 3min
            T_5MIN: 5min
            T_15MIN: 15min
            T_30MIN: 30min
            T_1HOUR: 1hour
            T_2HOUR: 2hour
            T_4HOUR: 4hour
            T_6HOUR: 6hour
            T_8HOUR: 8hour
            T_12HOUR: 12hour
            T_1DAY: 1day
            T_1WEEK: 1week
            T_1MONTH: 1month
        """
        T_1MIN = '1min'
        T_3MIN = '3min'
        T_5MIN = '5min'
        T_15MIN = '15min'
        T_30MIN = '30min'
        T_1HOUR = '1hour'
        T_2HOUR = '2hour'
        T_4HOUR = '4hour'
        T_6HOUR = '6hour'
        T_8HOUR = '8hour'
        T_12HOUR = '12hour'
        T_1DAY = '1day'
        T_1WEEK = '1week'
        T_1MONTH = '1month'

    symbol: Optional[str] = Field(default=None, description=" symbol")
    type: Optional[TypeEnum] = Field(
        default=None,
        description=
        "Type of candlestick patterns: 1min, 3min, 5min, 15min, 30min, 1hour, 2hour, 4hour, 6hour, 8hour, 12hour, 1day, 1week, 1month"
    )
    start_at: Optional[int] = Field(
        default=0,
        description="Start time (second), default is 0",
        alias="startAt")
    end_at: Optional[int] = Field(
        default=0,
        description="End time (second), default is 0",
        alias="endAt")

    __properties: ClassVar[List[str]] = ["symbol", "type", "startAt", "endAt"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=False,
        protected_namespaces=(),
    )

    def to_str(self) -> str:
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        return self.model_dump_json(by_alias=True, exclude_none=True)

    @classmethod
    def from_json(cls, json_str: str) -> Optional[GetKlinesReq]:
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        _dict = self.model_dump(
            by_alias=True,
            exclude_none=True,
        )
        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str,
                                          Any]]) -> Optional[GetKlinesReq]:
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "symbol":
            obj.get("symbol"),
            "type":
            obj.get("type"),
            "startAt":
            obj.get("startAt") if obj.get("startAt") is not None else 0,
            "endAt":
            obj.get("endAt") if obj.get("endAt") is not None else 0
        })
        return _obj


class GetKlinesReqBuilder:

    def __init__(self):
        self.obj = {}

    def set_symbol(self, value: str) -> GetKlinesReqBuilder:
        """
         symbol
        """
        self.obj['symbol'] = value
        return self

    def set_type(self, value: GetKlinesReq.TypeEnum) -> GetKlinesReqBuilder:
        """
        Type of candlestick patterns: 1min, 3min, 5min, 15min, 30min, 1hour, 2hour, 4hour, 6hour, 8hour, 12hour, 1day, 1week, 1month
        """
        self.obj['type'] = value
        return self

    def set_start_at(self, value: int) -> GetKlinesReqBuilder:
        """
        Start time (second), default is 0
        """
        self.obj['startAt'] = value
        return self

    def set_end_at(self, value: int) -> GetKlinesReqBuilder:
        """
        End time (second), default is 0
        """
        self.obj['endAt'] = value
        return self

    def build(self) -> GetKlinesReq:
        return GetKlinesReq(**self.obj)
