# coding: utf-8

# Code generated by Kucoin Universal SDK Generator; DO NOT EDIT.

from __future__ import annotations
import pprint
import json

from pydantic import BaseModel, ConfigDict, Field
from typing import Any, ClassVar, Dict, List, Optional
from kucoin_universal_sdk.internal.interfaces.response import Response
from kucoin_universal_sdk.model.common import RestResponse


class GetTickerResp(BaseModel, Response):
    """
    GetTickerResp

    Attributes:
        time (int): timestamp
        sequence (str): Sequence
        price (str): Last traded price
        size (str): Last traded size
        best_bid (str): Best bid price
        best_bid_size (str): Best bid size
        best_ask (str): Best ask price
        best_ask_size (str): Best ask size
    """

    common_response: Optional[RestResponse] = Field(
        default=None, description="Common response")
    time: Optional[int] = Field(default=None, description="timestamp")
    sequence: Optional[str] = Field(default=None, description="Sequence")
    price: Optional[str] = Field(default=None, description="Last traded price")
    size: Optional[str] = Field(default=None, description="Last traded size")
    best_bid: Optional[str] = Field(default=None,
                                    description="Best bid price",
                                    alias="bestBid")
    best_bid_size: Optional[str] = Field(default=None,
                                         description="Best bid size",
                                         alias="bestBidSize")
    best_ask: Optional[str] = Field(default=None,
                                    description="Best ask price",
                                    alias="bestAsk")
    best_ask_size: Optional[str] = Field(default=None,
                                         description="Best ask size",
                                         alias="bestAskSize")

    __properties: ClassVar[List[str]] = [
        "time", "sequence", "price", "size", "bestBid", "bestBidSize",
        "bestAsk", "bestAskSize"
    ]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=False,
        protected_namespaces=(),
    )

    def to_str(self) -> str:
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        return self.model_dump_json(by_alias=True, exclude_none=True)

    @classmethod
    def from_json(cls, json_str: str) -> Optional[GetTickerResp]:
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        _dict = self.model_dump(
            by_alias=True,
            exclude_none=True,
        )
        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str,
                                          Any]]) -> Optional[GetTickerResp]:
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "time": obj.get("time"),
            "sequence": obj.get("sequence"),
            "price": obj.get("price"),
            "size": obj.get("size"),
            "bestBid": obj.get("bestBid"),
            "bestBidSize": obj.get("bestBidSize"),
            "bestAsk": obj.get("bestAsk"),
            "bestAskSize": obj.get("bestAskSize")
        })
        return _obj

    def set_common_response(self, response: RestResponse):
        self.common_response = response
