# coding: utf-8

# Code generated by Kucoin Universal SDK Generator; DO NOT EDIT.

from __future__ import annotations
import pprint
import json

from pydantic import BaseModel, ConfigDict, Field
from typing import Any, ClassVar, Dict, List, Optional


class BatchCancelOcoOrdersReq(BaseModel):
    """
    BatchCancelOcoOrdersReq

    Attributes:
        order_ids (str): Specify the order ID; there can be multiple orders, separated by commas. If not passed, all OCO orders will be canceled by default.
        symbol (str): Trading pair. If not passed, the OCO orders of all symbols will be canceled by default.
    """

    order_ids: Optional[str] = Field(
        default=None,
        description=
        "Specify the order ID; there can be multiple orders, separated by commas. If not passed, all OCO orders will be canceled by default.",
        alias="orderIds")
    symbol: Optional[str] = Field(
        default=None,
        description=
        "Trading pair. If not passed, the OCO orders of all symbols will be canceled by default."
    )

    __properties: ClassVar[List[str]] = ["orderIds", "symbol"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=False,
        protected_namespaces=(),
    )

    def to_str(self) -> str:
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        return self.model_dump_json(by_alias=True, exclude_none=True)

    @classmethod
    def from_json(cls, json_str: str) -> Optional[BatchCancelOcoOrdersReq]:
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        _dict = self.model_dump(
            by_alias=True,
            exclude_none=True,
        )
        return _dict

    @classmethod
    def from_dict(
            cls,
            obj: Optional[Dict[str,
                               Any]]) -> Optional[BatchCancelOcoOrdersReq]:
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "orderIds": obj.get("orderIds"),
            "symbol": obj.get("symbol")
        })
        return _obj


class BatchCancelOcoOrdersReqBuilder:

    def __init__(self):
        self.obj = {}

    def set_order_ids(self, value: str) -> BatchCancelOcoOrdersReqBuilder:
        """
        Specify the order ID; there can be multiple orders, separated by commas. If not passed, all OCO orders will be canceled by default.
        """
        self.obj['orderIds'] = value
        return self

    def set_symbol(self, value: str) -> BatchCancelOcoOrdersReqBuilder:
        """
        Trading pair. If not passed, the OCO orders of all symbols will be canceled by default.
        """
        self.obj['symbol'] = value
        return self

    def build(self) -> BatchCancelOcoOrdersReq:
        return BatchCancelOcoOrdersReq(**self.obj)
