# coding: utf-8

# Code generated by Kucoin Universal SDK Generator; DO NOT EDIT.

from __future__ import annotations
import pprint
import json

from pydantic import BaseModel, ConfigDict, Field
from typing import Any, ClassVar, Dict, List, Optional
from kucoin_universal_sdk.internal.interfaces.response import Response
from kucoin_universal_sdk.model.common import RestResponse


class GetDcpResp(BaseModel, Response):
    """
    If the data is empty, it means that DCP is not set.

    Attributes:
        timeout (int): Auto cancel order trigger setting time, the unit is second. Range: timeout=-1 (meaning unset) or 5 <= timeout <= 86400
        symbols (str): List of trading pairs. Separated by commas; empty means all trading pairs
        current_time (int): System current time (in seconds)
        trigger_time (int): Trigger cancellation time (in seconds)
    """

    common_response: Optional[RestResponse] = Field(
        default=None, description="Common response")
    timeout: Optional[int] = Field(
        default=None,
        description=
        "Auto cancel order trigger setting time, the unit is second. Range: timeout=-1 (meaning unset) or 5 <= timeout <= 86400"
    )
    symbols: Optional[str] = Field(
        default=None,
        description=
        "List of trading pairs. Separated by commas; empty means all trading pairs"
    )
    current_time: Optional[int] = Field(
        default=None,
        description="System current time (in seconds)",
        alias="currentTime")
    trigger_time: Optional[int] = Field(
        default=None,
        description="Trigger cancellation time (in seconds)",
        alias="triggerTime")

    __properties: ClassVar[List[str]] = [
        "timeout", "symbols", "currentTime", "triggerTime"
    ]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=False,
        protected_namespaces=(),
    )

    def to_str(self) -> str:
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        return self.model_dump_json(by_alias=True, exclude_none=True)

    @classmethod
    def from_json(cls, json_str: str) -> Optional[GetDcpResp]:
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        _dict = self.model_dump(
            by_alias=True,
            exclude_none=True,
        )
        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[GetDcpResp]:
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "timeout": obj.get("timeout"),
            "symbols": obj.get("symbols"),
            "currentTime": obj.get("currentTime"),
            "triggerTime": obj.get("triggerTime")
        })
        return _obj

    def set_common_response(self, response: RestResponse):
        self.common_response = response
