# coding: utf-8

# Code generated by Kucoin Universal SDK Generator; DO NOT EDIT.

from __future__ import annotations
import pprint
import json

from pydantic import BaseModel, ConfigDict, Field
from typing import Any, ClassVar, Dict, List, Optional


class GetOpenOrdersByPageReq(BaseModel):
    """
    GetOpenOrdersByPageReq

    Attributes:
        symbol (str): Symbol
        page_num (int): Current page
        page_size (int): Size per page
    """

    symbol: Optional[str] = Field(default=None, description="Symbol")
    page_num: Optional[int] = Field(default=1,
                                    description="Current page",
                                    alias="pageNum")
    page_size: Optional[int] = Field(default=20,
                                     description="Size per page",
                                     alias="pageSize")

    __properties: ClassVar[List[str]] = ["symbol", "pageNum", "pageSize"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=False,
        protected_namespaces=(),
    )

    def to_str(self) -> str:
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        return self.model_dump_json(by_alias=True, exclude_none=True)

    @classmethod
    def from_json(cls, json_str: str) -> Optional[GetOpenOrdersByPageReq]:
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        _dict = self.model_dump(
            by_alias=True,
            exclude_none=True,
        )
        return _dict

    @classmethod
    def from_dict(
            cls, obj: Optional[Dict[str,
                                    Any]]) -> Optional[GetOpenOrdersByPageReq]:
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "symbol":
            obj.get("symbol"),
            "pageNum":
            obj.get("pageNum") if obj.get("pageNum") is not None else 1,
            "pageSize":
            obj.get("pageSize") if obj.get("pageSize") is not None else 20
        })
        return _obj


class GetOpenOrdersByPageReqBuilder:

    def __init__(self):
        self.obj = {}

    def set_symbol(self, value: str) -> GetOpenOrdersByPageReqBuilder:
        """
        Symbol
        """
        self.obj['symbol'] = value
        return self

    def set_page_num(self, value: int) -> GetOpenOrdersByPageReqBuilder:
        """
        Current page
        """
        self.obj['pageNum'] = value
        return self

    def set_page_size(self, value: int) -> GetOpenOrdersByPageReqBuilder:
        """
        Size per page
        """
        self.obj['pageSize'] = value
        return self

    def build(self) -> GetOpenOrdersByPageReq:
        return GetOpenOrdersByPageReq(**self.obj)
