# coding: utf-8

# Code generated by Kucoin Universal SDK Generator; DO NOT EDIT.

from __future__ import annotations
import pprint
import json

from enum import Enum
from pydantic import BaseModel, ConfigDict, Field
from typing import Any, ClassVar, Dict, List, Optional


class GetStopOrdersListReq(BaseModel):
    """
    GetStopOrdersListReq

    Attributes:
        symbol (str): Only list orders for a specific symbol
        side (str): buy or sell
        type (TypeEnum): limit, market
        trade_type (str): The type of trading : TRADE（Spot）, MARGIN_TRADE (Cross Margin), MARGIN_ISOLATED_TRADE (Isolated Margin). Default is TRADE
        start_at (int): Start time (milisecond)
        end_at (int): End time (milisecond)
        current_page (int): Current page 
        order_ids (str): Comma seperated order ID list
        page_size (int): Page size
        stop (str): Order type: stop: stop loss order, oco: oco order
    """

    class TypeEnum(Enum):
        """
        Attributes:
            LIMIT: limit order
            MARKET: market order
        """
        LIMIT = 'limit'
        MARKET = 'market'

    symbol: Optional[str] = Field(
        default=None, description="Only list orders for a specific symbol")
    side: Optional[str] = Field(default=None, description="buy or sell")
    type: Optional[TypeEnum] = Field(default=None, description="limit, market")
    trade_type: Optional[str] = Field(
        default=None,
        description=
        "The type of trading : TRADE（Spot）, MARGIN_TRADE (Cross Margin), MARGIN_ISOLATED_TRADE (Isolated Margin). Default is TRADE",
        alias="tradeType")
    start_at: Optional[int] = Field(default=None,
                                    description="Start time (milisecond)",
                                    alias="startAt")
    end_at: Optional[int] = Field(default=None,
                                  description="End time (milisecond)",
                                  alias="endAt")
    current_page: Optional[int] = Field(default=1,
                                        description="Current page ",
                                        alias="currentPage")
    order_ids: Optional[str] = Field(
        default=None,
        description="Comma seperated order ID list",
        alias="orderIds")
    page_size: Optional[int] = Field(default=50,
                                     description="Page size",
                                     alias="pageSize")
    stop: Optional[str] = Field(
        default=None,
        description="Order type: stop: stop loss order, oco: oco order")

    __properties: ClassVar[List[str]] = [
        "symbol", "side", "type", "tradeType", "startAt", "endAt",
        "currentPage", "orderIds", "pageSize", "stop"
    ]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=False,
        protected_namespaces=(),
    )

    def to_str(self) -> str:
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        return self.model_dump_json(by_alias=True, exclude_none=True)

    @classmethod
    def from_json(cls, json_str: str) -> Optional[GetStopOrdersListReq]:
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        _dict = self.model_dump(
            by_alias=True,
            exclude_none=True,
        )
        return _dict

    @classmethod
    def from_dict(
            cls, obj: Optional[Dict[str,
                                    Any]]) -> Optional[GetStopOrdersListReq]:
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "symbol":
            obj.get("symbol"),
            "side":
            obj.get("side"),
            "type":
            obj.get("type"),
            "tradeType":
            obj.get("tradeType"),
            "startAt":
            obj.get("startAt"),
            "endAt":
            obj.get("endAt"),
            "currentPage":
            obj.get("currentPage")
            if obj.get("currentPage") is not None else 1,
            "orderIds":
            obj.get("orderIds"),
            "pageSize":
            obj.get("pageSize") if obj.get("pageSize") is not None else 50,
            "stop":
            obj.get("stop")
        })
        return _obj


class GetStopOrdersListReqBuilder:

    def __init__(self):
        self.obj = {}

    def set_symbol(self, value: str) -> GetStopOrdersListReqBuilder:
        """
        Only list orders for a specific symbol
        """
        self.obj['symbol'] = value
        return self

    def set_side(self, value: str) -> GetStopOrdersListReqBuilder:
        """
        buy or sell
        """
        self.obj['side'] = value
        return self

    def set_type(
            self, value: GetStopOrdersListReq.TypeEnum
    ) -> GetStopOrdersListReqBuilder:
        """
        limit, market
        """
        self.obj['type'] = value
        return self

    def set_trade_type(self, value: str) -> GetStopOrdersListReqBuilder:
        """
        The type of trading : TRADE（Spot）, MARGIN_TRADE (Cross Margin), MARGIN_ISOLATED_TRADE (Isolated Margin). Default is TRADE
        """
        self.obj['tradeType'] = value
        return self

    def set_start_at(self, value: int) -> GetStopOrdersListReqBuilder:
        """
        Start time (milisecond)
        """
        self.obj['startAt'] = value
        return self

    def set_end_at(self, value: int) -> GetStopOrdersListReqBuilder:
        """
        End time (milisecond)
        """
        self.obj['endAt'] = value
        return self

    def set_current_page(self, value: int) -> GetStopOrdersListReqBuilder:
        """
        Current page 
        """
        self.obj['currentPage'] = value
        return self

    def set_order_ids(self, value: str) -> GetStopOrdersListReqBuilder:
        """
        Comma seperated order ID list
        """
        self.obj['orderIds'] = value
        return self

    def set_page_size(self, value: int) -> GetStopOrdersListReqBuilder:
        """
        Page size
        """
        self.obj['pageSize'] = value
        return self

    def set_stop(self, value: str) -> GetStopOrdersListReqBuilder:
        """
        Order type: stop: stop loss order, oco: oco order
        """
        self.obj['stop'] = value
        return self

    def build(self) -> GetStopOrdersListReq:
        return GetStopOrdersListReq(**self.obj)
