# coding: utf-8

# Code generated by Kucoin Universal SDK Generator; DO NOT EDIT.

from __future__ import annotations
import pprint
import json

from pydantic import BaseModel, ConfigDict, Field
from typing import Any, ClassVar, Dict, List, Optional


class GetTradeHistoryOldItems(BaseModel):
    """
    GetTradeHistoryOldItems

    Attributes:
        symbol (str): symbol
        trade_id (str): 
        order_id (str): The unique order id generated by the trading system
        counter_order_id (str): Counterparty order ID
        side (str): Buy or sell
        liquidity (str): Liquidity type: taker or maker
        force_taker (bool): 
        price (str): Order Price
        size (str): Order Size
        funds (str): Order Funds
        fee (str): [Handling fees](https://www.kucoin.com/docs-new/api-5327739)
        fee_rate (str): Fee rate 
        fee_currency (str): Currency used to calculate trading fee
        stop (str): Take Profit and Stop Loss type, currently HFT does not support the Take Profit and Stop Loss type, so it is empty
        trade_type (str): Trade type, redundancy param
        type (str): Specify if the order is a 'limit' order or 'market' order. 
        created_at (int): 
    """

    symbol: Optional[str] = Field(default=None, description="symbol")
    trade_id: Optional[str] = Field(default=None, alias="tradeId")
    order_id: Optional[str] = Field(
        default=None,
        description="The unique order id generated by the trading system",
        alias="orderId")
    counter_order_id: Optional[str] = Field(
        default=None,
        description="Counterparty order ID",
        alias="counterOrderId")
    side: Optional[str] = Field(default=None, description="Buy or sell")
    liquidity: Optional[str] = Field(
        default=None, description="Liquidity type: taker or maker")
    force_taker: Optional[bool] = Field(default=None, alias="forceTaker")
    price: Optional[str] = Field(default=None, description="Order Price")
    size: Optional[str] = Field(default=None, description="Order Size")
    funds: Optional[str] = Field(default=None, description="Order Funds")
    fee: Optional[str] = Field(
        default=None,
        description=
        "[Handling fees](https://www.kucoin.com/docs-new/api-5327739)")
    fee_rate: Optional[str] = Field(default=None,
                                    description="Fee rate ",
                                    alias="feeRate")
    fee_currency: Optional[str] = Field(
        default=None,
        description="Currency used to calculate trading fee",
        alias="feeCurrency")
    stop: Optional[str] = Field(
        default=None,
        description=
        "Take Profit and Stop Loss type, currently HFT does not support the Take Profit and Stop Loss type, so it is empty"
    )
    trade_type: Optional[str] = Field(
        default=None,
        description="Trade type, redundancy param",
        alias="tradeType")
    type: Optional[str] = Field(
        default=None,
        description=
        "Specify if the order is a 'limit' order or 'market' order. ")
    created_at: Optional[int] = Field(default=None, alias="createdAt")

    __properties: ClassVar[List[str]] = [
        "symbol", "tradeId", "orderId", "counterOrderId", "side", "liquidity",
        "forceTaker", "price", "size", "funds", "fee", "feeRate",
        "feeCurrency", "stop", "tradeType", "type", "createdAt"
    ]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=False,
        protected_namespaces=(),
    )

    def to_str(self) -> str:
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        return self.model_dump_json(by_alias=True, exclude_none=True)

    @classmethod
    def from_json(cls, json_str: str) -> Optional[GetTradeHistoryOldItems]:
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        _dict = self.model_dump(
            by_alias=True,
            exclude_none=True,
        )
        return _dict

    @classmethod
    def from_dict(
            cls,
            obj: Optional[Dict[str,
                               Any]]) -> Optional[GetTradeHistoryOldItems]:
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "symbol": obj.get("symbol"),
            "tradeId": obj.get("tradeId"),
            "orderId": obj.get("orderId"),
            "counterOrderId": obj.get("counterOrderId"),
            "side": obj.get("side"),
            "liquidity": obj.get("liquidity"),
            "forceTaker": obj.get("forceTaker"),
            "price": obj.get("price"),
            "size": obj.get("size"),
            "funds": obj.get("funds"),
            "fee": obj.get("fee"),
            "feeRate": obj.get("feeRate"),
            "feeCurrency": obj.get("feeCurrency"),
            "stop": obj.get("stop"),
            "tradeType": obj.get("tradeType"),
            "type": obj.get("type"),
            "createdAt": obj.get("createdAt")
        })
        return _obj
