# coding: utf-8

# Code generated by Kucoin Universal SDK Generator; DO NOT EDIT.

from __future__ import annotations
import pprint
import json

from pydantic import BaseModel, ConfigDict, Field
from typing import Any, ClassVar, Dict, List, Optional


class ModifyOrderReq(BaseModel):
    """
    ModifyOrderReq

    Attributes:
        client_oid (str): One must be chose out of the old client order ID, orderId and clientOid
        symbol (str): symbol
        order_id (str): One must be chosen out of the old order id, orderId and clientOid
        new_price (str): One must be chosen out of the modified price of the new order, newPrice and newSize
        new_size (str): One must be chosen out of the modified size of the new order, newPrice and newSize
    """

    client_oid: Optional[str] = Field(
        default=None,
        description=
        "One must be chose out of the old client order ID, orderId and clientOid",
        alias="clientOid")
    symbol: Optional[str] = Field(default=None, description="symbol")
    order_id: Optional[str] = Field(
        default=None,
        description=
        "One must be chosen out of the old order id, orderId and clientOid",
        alias="orderId")
    new_price: Optional[str] = Field(
        default=None,
        description=
        "One must be chosen out of the modified price of the new order, newPrice and newSize",
        alias="newPrice")
    new_size: Optional[str] = Field(
        default=None,
        description=
        "One must be chosen out of the modified size of the new order, newPrice and newSize",
        alias="newSize")

    __properties: ClassVar[List[str]] = [
        "clientOid", "symbol", "orderId", "newPrice", "newSize"
    ]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=False,
        protected_namespaces=(),
    )

    def to_str(self) -> str:
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        return self.model_dump_json(by_alias=True, exclude_none=True)

    @classmethod
    def from_json(cls, json_str: str) -> Optional[ModifyOrderReq]:
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        _dict = self.model_dump(
            by_alias=True,
            exclude_none=True,
        )
        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str,
                                          Any]]) -> Optional[ModifyOrderReq]:
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "clientOid": obj.get("clientOid"),
            "symbol": obj.get("symbol"),
            "orderId": obj.get("orderId"),
            "newPrice": obj.get("newPrice"),
            "newSize": obj.get("newSize")
        })
        return _obj


class ModifyOrderReqBuilder:

    def __init__(self):
        self.obj = {}

    def set_client_oid(self, value: str) -> ModifyOrderReqBuilder:
        """
        One must be chose out of the old client order ID, orderId and clientOid
        """
        self.obj['clientOid'] = value
        return self

    def set_symbol(self, value: str) -> ModifyOrderReqBuilder:
        """
        symbol
        """
        self.obj['symbol'] = value
        return self

    def set_order_id(self, value: str) -> ModifyOrderReqBuilder:
        """
        One must be chosen out of the old order id, orderId and clientOid
        """
        self.obj['orderId'] = value
        return self

    def set_new_price(self, value: str) -> ModifyOrderReqBuilder:
        """
        One must be chosen out of the modified price of the new order, newPrice and newSize
        """
        self.obj['newPrice'] = value
        return self

    def set_new_size(self, value: str) -> ModifyOrderReqBuilder:
        """
        One must be chosen out of the modified size of the new order, newPrice and newSize
        """
        self.obj['newSize'] = value
        return self

    def build(self) -> ModifyOrderReq:
        return ModifyOrderReq(**self.obj)
