# coding: utf-8

# Code generated by Kucoin Universal SDK Generator; DO NOT EDIT.

from __future__ import annotations
import pprint
import json

from pydantic import BaseModel, ConfigDict, Field
from typing import Any, Callable, ClassVar, Dict, List, Optional
from .model_account_relation_context import AccountRelationContext
from kucoin_universal_sdk.internal.interfaces.websocket import WebSocketMessageCallback
from kucoin_universal_sdk.model.common import WsMessage


class AccountEvent(BaseModel):
    """
    AccountEvent

    Attributes:
        account_id (str): Account ID
        available (str): Funds available to withdraw or trade
        available_change (str): The change of available Funds
        currency (str): currency
        hold (str): Funds on hold (not available for use)
        hold_change (str): The change of hold funds
        relation_context (AccountRelationContext): 
        relation_event (str): Relation event
        relation_event_id (str): Relation event Id
        time (str): 
        total (str): Total balance = available + hold
    """

    common_response: Optional[WsMessage] = Field(default=None,
                                                 description="Common response")
    account_id: Optional[str] = Field(default=None,
                                      description="Account ID",
                                      alias="accountId")
    available: Optional[str] = Field(
        default=None, description="Funds available to withdraw or trade")
    available_change: Optional[str] = Field(
        default=None,
        description="The change of available Funds",
        alias="availableChange")
    currency: Optional[str] = Field(default=None, description="currency")
    hold: Optional[str] = Field(
        default=None, description="Funds on hold (not available for use)")
    hold_change: Optional[str] = Field(default=None,
                                       description="The change of hold funds",
                                       alias="holdChange")
    relation_context: Optional[AccountRelationContext] = Field(
        default=None, alias="relationContext")
    relation_event: Optional[str] = Field(default=None,
                                          description="Relation event",
                                          alias="relationEvent")
    relation_event_id: Optional[str] = Field(default=None,
                                             description="Relation event Id",
                                             alias="relationEventId")
    time: Optional[str] = None
    total: Optional[str] = Field(
        default=None, description="Total balance = available + hold")

    __properties: ClassVar[List[str]] = [
        "accountId", "available", "availableChange", "currency", "hold",
        "holdChange", "relationContext", "relationEvent", "relationEventId",
        "time", "total"
    ]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=False,
        protected_namespaces=(),
    )

    def to_str(self) -> str:
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        return self.model_dump_json(by_alias=True, exclude_none=True)

    @classmethod
    def from_json(cls, json_str: str) -> Optional[AccountEvent]:
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        _dict = self.model_dump(
            by_alias=True,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of relation_context
        if self.relation_context:
            _dict['relationContext'] = self.relation_context.to_dict()
        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str,
                                          Any]]) -> Optional[AccountEvent]:
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "accountId":
            obj.get("accountId"),
            "available":
            obj.get("available"),
            "availableChange":
            obj.get("availableChange"),
            "currency":
            obj.get("currency"),
            "hold":
            obj.get("hold"),
            "holdChange":
            obj.get("holdChange"),
            "relationContext":
            AccountRelationContext.from_dict(obj["relationContext"])
            if obj.get("relationContext") is not None else None,
            "relationEvent":
            obj.get("relationEvent"),
            "relationEventId":
            obj.get("relationEventId"),
            "time":
            obj.get("time"),
            "total":
            obj.get("total")
        })
        return _obj


AccountEventCallback = Callable[[str, str, AccountEvent], None]
"""
args:
    - topic (str) : topic
    - subject (str): subject
    - data (AccountEvent): event data
"""


class AccountEventCallbackWrapper(WebSocketMessageCallback):

    def __init__(self, cb: AccountEventCallback):
        self.callback = cb

    def on_message(self, message: WsMessage):
        event = AccountEvent.from_dict(message.raw_data)
        event.common_response = message
        self.callback(message.topic, message.subject, event)
