# coding: utf-8

# Code generated by Kucoin Universal SDK Generator; DO NOT EDIT.

from __future__ import annotations
import pprint
import json

from pydantic import BaseModel, ConfigDict, Field
from typing import Any, Callable, ClassVar, Dict, List, Optional
from kucoin_universal_sdk.internal.interfaces.websocket import WebSocketMessageCallback
from kucoin_universal_sdk.model.common import WsMessage


class CallAuctionInfoEvent(BaseModel):
    """
    CallAuctionInfoEvent

    Attributes:
        symbol (str): Symbol
        estimated_price (str): Estimated price
        estimated_size (str): Estimated size
        sell_order_range_low_price (str): Sell ​​order minimum price
        sell_order_range_high_price (str): Sell ​​order maximum price
        buy_order_range_low_price (str): Buy ​​order minimum price
        buy_order_range_high_price (str): Buy ​​order maximum price
        time (int): Timestamp (ms)
    """

    common_response: Optional[WsMessage] = Field(default=None,
                                                 description="Common response")
    symbol: Optional[str] = Field(default=None, description="Symbol")
    estimated_price: Optional[str] = Field(default=None,
                                           description="Estimated price",
                                           alias="estimatedPrice")
    estimated_size: Optional[str] = Field(default=None,
                                          description="Estimated size",
                                          alias="estimatedSize")
    sell_order_range_low_price: Optional[str] = Field(
        default=None,
        description="Sell ​​order minimum price",
        alias="sellOrderRangeLowPrice")
    sell_order_range_high_price: Optional[str] = Field(
        default=None,
        description="Sell ​​order maximum price",
        alias="sellOrderRangeHighPrice")
    buy_order_range_low_price: Optional[str] = Field(
        default=None,
        description="Buy ​​order minimum price",
        alias="buyOrderRangeLowPrice")
    buy_order_range_high_price: Optional[str] = Field(
        default=None,
        description="Buy ​​order maximum price",
        alias="buyOrderRangeHighPrice")
    time: Optional[int] = Field(default=None, description="Timestamp (ms)")

    __properties: ClassVar[List[str]] = [
        "symbol", "estimatedPrice", "estimatedSize", "sellOrderRangeLowPrice",
        "sellOrderRangeHighPrice", "buyOrderRangeLowPrice",
        "buyOrderRangeHighPrice", "time"
    ]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=False,
        protected_namespaces=(),
    )

    def to_str(self) -> str:
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        return self.model_dump_json(by_alias=True, exclude_none=True)

    @classmethod
    def from_json(cls, json_str: str) -> Optional[CallAuctionInfoEvent]:
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        _dict = self.model_dump(
            by_alias=True,
            exclude_none=True,
        )
        return _dict

    @classmethod
    def from_dict(
            cls, obj: Optional[Dict[str,
                                    Any]]) -> Optional[CallAuctionInfoEvent]:
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "symbol":
            obj.get("symbol"),
            "estimatedPrice":
            obj.get("estimatedPrice"),
            "estimatedSize":
            obj.get("estimatedSize"),
            "sellOrderRangeLowPrice":
            obj.get("sellOrderRangeLowPrice"),
            "sellOrderRangeHighPrice":
            obj.get("sellOrderRangeHighPrice"),
            "buyOrderRangeLowPrice":
            obj.get("buyOrderRangeLowPrice"),
            "buyOrderRangeHighPrice":
            obj.get("buyOrderRangeHighPrice"),
            "time":
            obj.get("time")
        })
        return _obj


CallAuctionInfoEventCallback = Callable[[str, str, CallAuctionInfoEvent], None]
"""
args:
    - topic (str) : topic
    - subject (str): subject
    - data (CallAuctionInfoEvent): event data
"""


class CallAuctionInfoEventCallbackWrapper(WebSocketMessageCallback):

    def __init__(self, cb: CallAuctionInfoEventCallback):
        self.callback = cb

    def on_message(self, message: WsMessage):
        event = CallAuctionInfoEvent.from_dict(message.raw_data)
        event.common_response = message
        self.callback(message.topic, message.subject, event)
