# coding: utf-8

# Code generated by Kucoin Universal SDK Generator; DO NOT EDIT.

from __future__ import annotations
import pprint
import json

from pydantic import BaseModel, ConfigDict, Field
from typing import Any, Callable, ClassVar, Dict, List, Optional
from kucoin_universal_sdk.internal.interfaces.websocket import WebSocketMessageCallback
from kucoin_universal_sdk.model.common import WsMessage


class TickerEvent(BaseModel):
    """
    TickerEvent

    Attributes:
        sequence (str): Sequence number
        price (str): Last traded price
        size (str): Last traded amount
        best_ask (str): Best ask price
        best_ask_size (str): Best ask size
        best_bid (str): Best bid price
        best_bid_size (str): Best bid size
        time (int): The matching time of the latest transaction
    """

    common_response: Optional[WsMessage] = Field(default=None,
                                                 description="Common response")
    sequence: Optional[str] = Field(default=None,
                                    description="Sequence number")
    price: Optional[str] = Field(default=None, description="Last traded price")
    size: Optional[str] = Field(default=None, description="Last traded amount")
    best_ask: Optional[str] = Field(default=None,
                                    description="Best ask price",
                                    alias="bestAsk")
    best_ask_size: Optional[str] = Field(default=None,
                                         description="Best ask size",
                                         alias="bestAskSize")
    best_bid: Optional[str] = Field(default=None,
                                    description="Best bid price",
                                    alias="bestBid")
    best_bid_size: Optional[str] = Field(default=None,
                                         description="Best bid size",
                                         alias="bestBidSize")
    time: Optional[int] = Field(
        default=None,
        description="The matching time of the latest transaction")

    __properties: ClassVar[List[str]] = [
        "sequence", "price", "size", "bestAsk", "bestAskSize", "bestBid",
        "bestBidSize", "time"
    ]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=False,
        protected_namespaces=(),
    )

    def to_str(self) -> str:
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        return self.model_dump_json(by_alias=True, exclude_none=True)

    @classmethod
    def from_json(cls, json_str: str) -> Optional[TickerEvent]:
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        _dict = self.model_dump(
            by_alias=True,
            exclude_none=True,
        )
        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[TickerEvent]:
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "sequence": obj.get("sequence"),
            "price": obj.get("price"),
            "size": obj.get("size"),
            "bestAsk": obj.get("bestAsk"),
            "bestAskSize": obj.get("bestAskSize"),
            "bestBid": obj.get("bestBid"),
            "bestBidSize": obj.get("bestBidSize"),
            "time": obj.get("time")
        })
        return _obj


TickerEventCallback = Callable[[str, str, TickerEvent], None]
"""
args:
    - topic (str) : topic
    - subject (str): subject
    - data (TickerEvent): event data
"""


class TickerEventCallbackWrapper(WebSocketMessageCallback):

    def __init__(self, cb: TickerEventCallback):
        self.callback = cb

    def on_message(self, message: WsMessage):
        event = TickerEvent.from_dict(message.raw_data)
        event.common_response = message
        self.callback(message.topic, message.subject, event)
