# coding: utf-8

# Code generated by Kucoin Universal SDK Generator; DO NOT EDIT.

from __future__ import annotations
import pprint
import json

from pydantic import BaseModel, ConfigDict, Field
from typing import Any, Callable, ClassVar, Dict, List, Optional
from kucoin_universal_sdk.internal.interfaces.websocket import WebSocketMessageCallback
from kucoin_universal_sdk.model.common import WsMessage


class TradeEvent(BaseModel):
    """
    TradeEvent

    Attributes:
        maker_order_id (str): 
        price (str): 
        sequence (str): 
        side (str): 
        size (str): 
        symbol (str): 
        taker_order_id (str): 
        time (str): 
        trade_id (str): 
        type (str): 
    """

    common_response: Optional[WsMessage] = Field(default=None,
                                                 description="Common response")
    maker_order_id: Optional[str] = Field(default=None, alias="makerOrderId")
    price: Optional[str] = None
    sequence: Optional[str] = None
    side: Optional[str] = None
    size: Optional[str] = None
    symbol: Optional[str] = None
    taker_order_id: Optional[str] = Field(default=None, alias="takerOrderId")
    time: Optional[str] = None
    trade_id: Optional[str] = Field(default=None, alias="tradeId")
    type: Optional[str] = None

    __properties: ClassVar[List[str]] = [
        "makerOrderId", "price", "sequence", "side", "size", "symbol",
        "takerOrderId", "time", "tradeId", "type"
    ]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=False,
        protected_namespaces=(),
    )

    def to_str(self) -> str:
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        return self.model_dump_json(by_alias=True, exclude_none=True)

    @classmethod
    def from_json(cls, json_str: str) -> Optional[TradeEvent]:
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        _dict = self.model_dump(
            by_alias=True,
            exclude_none=True,
        )
        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[TradeEvent]:
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "makerOrderId": obj.get("makerOrderId"),
            "price": obj.get("price"),
            "sequence": obj.get("sequence"),
            "side": obj.get("side"),
            "size": obj.get("size"),
            "symbol": obj.get("symbol"),
            "takerOrderId": obj.get("takerOrderId"),
            "time": obj.get("time"),
            "tradeId": obj.get("tradeId"),
            "type": obj.get("type")
        })
        return _obj


TradeEventCallback = Callable[[str, str, TradeEvent], None]
"""
args:
    - topic (str) : topic
    - subject (str): subject
    - data (TradeEvent): event data
"""


class TradeEventCallbackWrapper(WebSocketMessageCallback):

    def __init__(self, cb: TradeEventCallback):
        self.callback = cb

    def on_message(self, message: WsMessage):
        event = TradeEvent.from_dict(message.raw_data)
        event.common_response = message
        self.callback(message.topic, message.subject, event)
