# coding: utf-8

# Code generated by Kucoin Universal SDK Generator; DO NOT EDIT.

from __future__ import annotations
import pprint
import json

from pydantic import BaseModel, ConfigDict, Field
from typing import Any, ClassVar, Dict, List, Optional
from .model_get_discount_rate_configs_data_usdt_levels import GetDiscountRateConfigsDataUsdtLevels


class GetDiscountRateConfigsData(BaseModel):
    """
    GetDiscountRateConfigsData

    Attributes:
        currency (str): Currency
        usdt_levels (list[GetDiscountRateConfigsDataUsdtLevels]): Gradient configuration list, amount converted into USDT
    """

    currency: Optional[str] = Field(default=None, description="Currency")
    usdt_levels: Optional[List[GetDiscountRateConfigsDataUsdtLevels]] = Field(
        default=None,
        description="Gradient configuration list, amount converted into USDT",
        alias="usdtLevels")

    __properties: ClassVar[List[str]] = ["currency", "usdtLevels"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=False,
        protected_namespaces=(),
    )

    def to_str(self) -> str:
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        return self.model_dump_json(by_alias=True, exclude_none=True)

    @classmethod
    def from_json(cls, json_str: str) -> Optional[GetDiscountRateConfigsData]:
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        _dict = self.model_dump(
            by_alias=True,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of each item in usdt_levels (list)
        _items = []
        if self.usdt_levels:
            for _item_usdt_levels in self.usdt_levels:
                if _item_usdt_levels:
                    _items.append(_item_usdt_levels.to_dict())
            _dict['usdtLevels'] = _items
        return _dict

    @classmethod
    def from_dict(
            cls,
            obj: Optional[Dict[str,
                               Any]]) -> Optional[GetDiscountRateConfigsData]:
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "currency":
            obj.get("currency"),
            "usdtLevels": [
                GetDiscountRateConfigsDataUsdtLevels.from_dict(_item)
                for _item in obj["usdtLevels"]
            ] if obj.get("usdtLevels") is not None else None
        })
        return _obj
