# coding: utf-8

# Code generated by Kucoin Universal SDK Generator; DO NOT EDIT.

from __future__ import annotations
import pprint
import json

from pydantic import BaseModel, ConfigDict, Field
from typing import Any, ClassVar, Dict, List, Optional


class GetDiscountRateConfigsDataUsdtLevels(BaseModel):
    """
    GetDiscountRateConfigsDataUsdtLevels

    Attributes:
        left (int): Left end point of gradient interval, left<amount<=right
        right (int): Right end point of gradient interval, left<amount<=right
        discount_rate (str): Discount rate
    """

    left: Optional[int] = Field(
        default=None,
        description="Left end point of gradient interval, left<amount<=right")
    right: Optional[int] = Field(
        default=None,
        description="Right end point of gradient interval, left<amount<=right")
    discount_rate: Optional[str] = Field(default=None,
                                         description="Discount rate",
                                         alias="discountRate")

    __properties: ClassVar[List[str]] = ["left", "right", "discountRate"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=False,
        protected_namespaces=(),
    )

    def to_str(self) -> str:
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        return self.model_dump_json(by_alias=True, exclude_none=True)

    @classmethod
    def from_json(
            cls,
            json_str: str) -> Optional[GetDiscountRateConfigsDataUsdtLevels]:
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        _dict = self.model_dump(
            by_alias=True,
            exclude_none=True,
        )
        return _dict

    @classmethod
    def from_dict(
        cls, obj: Optional[Dict[str, Any]]
    ) -> Optional[GetDiscountRateConfigsDataUsdtLevels]:
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "left": obj.get("left"),
            "right": obj.get("right"),
            "discountRate": obj.get("discountRate")
        })
        return _obj
