# coding: utf-8

# Code generated by Kucoin Universal SDK Generator; DO NOT EDIT.

from __future__ import annotations
import pprint
import json

from pydantic import BaseModel, ConfigDict, Field
from typing import Any, ClassVar, Dict, List, Optional


class GetLoanInfoLtv(BaseModel):
    """
    Loan-to-Value Ratio 

    Attributes:
        transfer_ltv (str): LTV of Restricted Transfers to Funding Account
        only_close_pos_ltv (str): LTV of Reduce Only (Restricted Open Positions)
        delayed_liquidation_ltv (str): LTV of Delayed Liquidation
        instant_liquidation_ltv (str): LTV of Instant Liquidation
        current_ltv (str): Current LTV
    """

    transfer_ltv: Optional[str] = Field(
        default=None,
        description="LTV of Restricted Transfers to Funding Account",
        alias="transferLtv")
    only_close_pos_ltv: Optional[str] = Field(
        default=None,
        description="LTV of Reduce Only (Restricted Open Positions)",
        alias="onlyClosePosLtv")
    delayed_liquidation_ltv: Optional[str] = Field(
        default=None,
        description="LTV of Delayed Liquidation",
        alias="delayedLiquidationLtv")
    instant_liquidation_ltv: Optional[str] = Field(
        default=None,
        description="LTV of Instant Liquidation",
        alias="instantLiquidationLtv")
    current_ltv: Optional[str] = Field(default=None,
                                       description="Current LTV",
                                       alias="currentLtv")

    __properties: ClassVar[List[str]] = [
        "transferLtv", "onlyClosePosLtv", "delayedLiquidationLtv",
        "instantLiquidationLtv", "currentLtv"
    ]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=False,
        protected_namespaces=(),
    )

    def to_str(self) -> str:
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        return self.model_dump_json(by_alias=True, exclude_none=True)

    @classmethod
    def from_json(cls, json_str: str) -> Optional[GetLoanInfoLtv]:
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        _dict = self.model_dump(
            by_alias=True,
            exclude_none=True,
        )
        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str,
                                          Any]]) -> Optional[GetLoanInfoLtv]:
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "transferLtv":
            obj.get("transferLtv"),
            "onlyClosePosLtv":
            obj.get("onlyClosePosLtv"),
            "delayedLiquidationLtv":
            obj.get("delayedLiquidationLtv"),
            "instantLiquidationLtv":
            obj.get("instantLiquidationLtv"),
            "currentLtv":
            obj.get("currentLtv")
        })
        return _obj
