# coding: utf-8

# Code generated by Kucoin Universal SDK Generator; DO NOT EDIT.

from __future__ import annotations
import pprint
import json

from pydantic import BaseModel, ConfigDict, Field
from typing import Any, ClassVar, Dict, List, Optional
from .model_get_loan_info_ltv import GetLoanInfoLtv
from .model_get_loan_info_margins import GetLoanInfoMargins
from .model_get_loan_info_orders import GetLoanInfoOrders
from kucoin_universal_sdk.internal.interfaces.response import Response
from kucoin_universal_sdk.model.common import RestResponse


class GetLoanInfoResp(BaseModel, Response):
    """
    GetLoanInfoResp

    Attributes:
        parent_uid (str): Master UID
        orders (list[GetLoanInfoOrders]): Loan Orders
        ltv (GetLoanInfoLtv): 
        total_margin_amount (str): Total Margin Amount (USDT)
        transfer_margin_amount (str): Total Maintenance Margin for Restricted Transfers (USDT)
        margins (list[GetLoanInfoMargins]): 
    """

    common_response: Optional[RestResponse] = Field(
        default=None, description="Common response")
    parent_uid: Optional[str] = Field(default=None,
                                      description="Master UID",
                                      alias="parentUid")
    orders: Optional[List[GetLoanInfoOrders]] = Field(
        default=None, description="Loan Orders")
    ltv: Optional[GetLoanInfoLtv] = None
    total_margin_amount: Optional[str] = Field(
        default=None,
        description="Total Margin Amount (USDT)",
        alias="totalMarginAmount")
    transfer_margin_amount: Optional[str] = Field(
        default=None,
        description="Total Maintenance Margin for Restricted Transfers (USDT)",
        alias="transferMarginAmount")
    margins: Optional[List[GetLoanInfoMargins]] = None

    __properties: ClassVar[List[str]] = [
        "parentUid", "orders", "ltv", "totalMarginAmount",
        "transferMarginAmount", "margins"
    ]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=False,
        protected_namespaces=(),
    )

    def to_str(self) -> str:
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        return self.model_dump_json(by_alias=True, exclude_none=True)

    @classmethod
    def from_json(cls, json_str: str) -> Optional[GetLoanInfoResp]:
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        _dict = self.model_dump(
            by_alias=True,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of each item in orders (list)
        _items = []
        if self.orders:
            for _item_orders in self.orders:
                if _item_orders:
                    _items.append(_item_orders.to_dict())
            _dict['orders'] = _items
        # override the default output from pydantic by calling `to_dict()` of ltv
        if self.ltv:
            _dict['ltv'] = self.ltv.to_dict()
        # override the default output from pydantic by calling `to_dict()` of each item in margins (list)
        _items = []
        if self.margins:
            for _item_margins in self.margins:
                if _item_margins:
                    _items.append(_item_margins.to_dict())
            _dict['margins'] = _items
        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str,
                                          Any]]) -> Optional[GetLoanInfoResp]:
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "parentUid":
            obj.get("parentUid"),
            "orders":
            [GetLoanInfoOrders.from_dict(_item) for _item in obj["orders"]]
            if obj.get("orders") is not None else None,
            "ltv":
            GetLoanInfoLtv.from_dict(obj["ltv"])
            if obj.get("ltv") is not None else None,
            "totalMarginAmount":
            obj.get("totalMarginAmount"),
            "transferMarginAmount":
            obj.get("transferMarginAmount"),
            "margins":
            [GetLoanInfoMargins.from_dict(_item) for _item in obj["margins"]]
            if obj.get("margins") is not None else None
        })
        return _obj

    def set_common_response(self, response: RestResponse):
        self.common_response = response
