import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface ApiManagementIdentityProviderAadConfig extends cdktf.TerraformMetaArguments {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/api_management_identity_provider_aad#allowed_tenants ApiManagementIdentityProviderAad#allowed_tenants}
    */
    readonly allowedTenants: string[];
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/api_management_identity_provider_aad#api_management_name ApiManagementIdentityProviderAad#api_management_name}
    */
    readonly apiManagementName: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/api_management_identity_provider_aad#client_id ApiManagementIdentityProviderAad#client_id}
    */
    readonly clientId: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/api_management_identity_provider_aad#client_secret ApiManagementIdentityProviderAad#client_secret}
    */
    readonly clientSecret: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/api_management_identity_provider_aad#resource_group_name ApiManagementIdentityProviderAad#resource_group_name}
    */
    readonly resourceGroupName: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/api_management_identity_provider_aad#signin_tenant ApiManagementIdentityProviderAad#signin_tenant}
    */
    readonly signinTenant?: string;
    /**
    * timeouts block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/api_management_identity_provider_aad#timeouts ApiManagementIdentityProviderAad#timeouts}
    */
    readonly timeouts?: ApiManagementIdentityProviderAadTimeouts;
}
export interface ApiManagementIdentityProviderAadTimeouts {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/api_management_identity_provider_aad#create ApiManagementIdentityProviderAad#create}
    */
    readonly create?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/api_management_identity_provider_aad#delete ApiManagementIdentityProviderAad#delete}
    */
    readonly delete?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/api_management_identity_provider_aad#read ApiManagementIdentityProviderAad#read}
    */
    readonly read?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/api_management_identity_provider_aad#update ApiManagementIdentityProviderAad#update}
    */
    readonly update?: string;
}
export declare function apiManagementIdentityProviderAadTimeoutsToTerraform(struct?: ApiManagementIdentityProviderAadTimeoutsOutputReference | ApiManagementIdentityProviderAadTimeouts | cdktf.IResolvable): any;
export declare class ApiManagementIdentityProviderAadTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param isSingleItem True if this is a block, false if it's a list
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, isSingleItem: boolean);
    get internalValue(): ApiManagementIdentityProviderAadTimeouts | undefined;
    set internalValue(value: ApiManagementIdentityProviderAadTimeouts | undefined);
    private _create?;
    get create(): string;
    set create(value: string);
    resetCreate(): void;
    get createInput(): string | undefined;
    private _delete?;
    get delete(): string;
    set delete(value: string);
    resetDelete(): void;
    get deleteInput(): string | undefined;
    private _read?;
    get read(): string;
    set read(value: string);
    resetRead(): void;
    get readInput(): string | undefined;
    private _update?;
    get update(): string;
    set update(value: string);
    resetUpdate(): void;
    get updateInput(): string | undefined;
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/azurerm/r/api_management_identity_provider_aad azurerm_api_management_identity_provider_aad}
*/
export declare class ApiManagementIdentityProviderAad extends cdktf.TerraformResource {
    static readonly tfResourceType: string;
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/azurerm/r/api_management_identity_provider_aad azurerm_api_management_identity_provider_aad} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options ApiManagementIdentityProviderAadConfig
    */
    constructor(scope: Construct, id: string, config: ApiManagementIdentityProviderAadConfig);
    private _allowedTenants?;
    get allowedTenants(): string[];
    set allowedTenants(value: string[]);
    get allowedTenantsInput(): string[] | undefined;
    private _apiManagementName?;
    get apiManagementName(): string;
    set apiManagementName(value: string);
    get apiManagementNameInput(): string | undefined;
    private _clientId?;
    get clientId(): string;
    set clientId(value: string);
    get clientIdInput(): string | undefined;
    private _clientSecret?;
    get clientSecret(): string;
    set clientSecret(value: string);
    get clientSecretInput(): string | undefined;
    get id(): string;
    private _resourceGroupName?;
    get resourceGroupName(): string;
    set resourceGroupName(value: string);
    get resourceGroupNameInput(): string | undefined;
    private _signinTenant?;
    get signinTenant(): string;
    set signinTenant(value: string);
    resetSigninTenant(): void;
    get signinTenantInput(): string | undefined;
    private _timeouts;
    get timeouts(): ApiManagementIdentityProviderAadTimeoutsOutputReference;
    putTimeouts(value: ApiManagementIdentityProviderAadTimeouts): void;
    resetTimeouts(): void;
    get timeoutsInput(): ApiManagementIdentityProviderAadTimeouts | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
