import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface AppServiceEnvironmentV3Config extends cdktf.TerraformMetaArguments {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/app_service_environment_v3#allow_new_private_endpoint_connections AppServiceEnvironmentV3#allow_new_private_endpoint_connections}
    */
    readonly allowNewPrivateEndpointConnections?: boolean | cdktf.IResolvable;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/app_service_environment_v3#dedicated_host_count AppServiceEnvironmentV3#dedicated_host_count}
    */
    readonly dedicatedHostCount?: number;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/app_service_environment_v3#internal_load_balancing_mode AppServiceEnvironmentV3#internal_load_balancing_mode}
    */
    readonly internalLoadBalancingMode?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/app_service_environment_v3#name AppServiceEnvironmentV3#name}
    */
    readonly name: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/app_service_environment_v3#resource_group_name AppServiceEnvironmentV3#resource_group_name}
    */
    readonly resourceGroupName: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/app_service_environment_v3#subnet_id AppServiceEnvironmentV3#subnet_id}
    */
    readonly subnetId: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/app_service_environment_v3#tags AppServiceEnvironmentV3#tags}
    */
    readonly tags?: {
        [key: string]: string;
    };
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/app_service_environment_v3#zone_redundant AppServiceEnvironmentV3#zone_redundant}
    */
    readonly zoneRedundant?: boolean | cdktf.IResolvable;
    /**
    * cluster_setting block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/app_service_environment_v3#cluster_setting AppServiceEnvironmentV3#cluster_setting}
    */
    readonly clusterSetting?: AppServiceEnvironmentV3ClusterSetting[] | cdktf.IResolvable;
    /**
    * timeouts block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/app_service_environment_v3#timeouts AppServiceEnvironmentV3#timeouts}
    */
    readonly timeouts?: AppServiceEnvironmentV3Timeouts;
}
export declare class AppServiceEnvironmentV3InboundNetworkDependencies extends cdktf.ComplexComputedList {
    get description(): string;
    get ipAddresses(): string[];
    get ports(): string[];
}
export interface AppServiceEnvironmentV3ClusterSetting {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/app_service_environment_v3#name AppServiceEnvironmentV3#name}
    */
    readonly name: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/app_service_environment_v3#value AppServiceEnvironmentV3#value}
    */
    readonly value: string;
}
export declare function appServiceEnvironmentV3ClusterSettingToTerraform(struct?: AppServiceEnvironmentV3ClusterSetting | cdktf.IResolvable): any;
export interface AppServiceEnvironmentV3Timeouts {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/app_service_environment_v3#create AppServiceEnvironmentV3#create}
    */
    readonly create?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/app_service_environment_v3#delete AppServiceEnvironmentV3#delete}
    */
    readonly delete?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/app_service_environment_v3#read AppServiceEnvironmentV3#read}
    */
    readonly read?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/app_service_environment_v3#update AppServiceEnvironmentV3#update}
    */
    readonly update?: string;
}
export declare function appServiceEnvironmentV3TimeoutsToTerraform(struct?: AppServiceEnvironmentV3TimeoutsOutputReference | AppServiceEnvironmentV3Timeouts | cdktf.IResolvable): any;
export declare class AppServiceEnvironmentV3TimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param isSingleItem True if this is a block, false if it's a list
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, isSingleItem: boolean);
    get internalValue(): AppServiceEnvironmentV3Timeouts | undefined;
    set internalValue(value: AppServiceEnvironmentV3Timeouts | undefined);
    private _create?;
    get create(): string;
    set create(value: string);
    resetCreate(): void;
    get createInput(): string | undefined;
    private _delete?;
    get delete(): string;
    set delete(value: string);
    resetDelete(): void;
    get deleteInput(): string | undefined;
    private _read?;
    get read(): string;
    set read(value: string);
    resetRead(): void;
    get readInput(): string | undefined;
    private _update?;
    get update(): string;
    set update(value: string);
    resetUpdate(): void;
    get updateInput(): string | undefined;
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/azurerm/r/app_service_environment_v3 azurerm_app_service_environment_v3}
*/
export declare class AppServiceEnvironmentV3 extends cdktf.TerraformResource {
    static readonly tfResourceType: string;
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/azurerm/r/app_service_environment_v3 azurerm_app_service_environment_v3} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options AppServiceEnvironmentV3Config
    */
    constructor(scope: Construct, id: string, config: AppServiceEnvironmentV3Config);
    private _allowNewPrivateEndpointConnections?;
    get allowNewPrivateEndpointConnections(): boolean | cdktf.IResolvable;
    set allowNewPrivateEndpointConnections(value: boolean | cdktf.IResolvable);
    resetAllowNewPrivateEndpointConnections(): void;
    get allowNewPrivateEndpointConnectionsInput(): boolean | cdktf.IResolvable | undefined;
    private _dedicatedHostCount?;
    get dedicatedHostCount(): number;
    set dedicatedHostCount(value: number);
    resetDedicatedHostCount(): void;
    get dedicatedHostCountInput(): number | undefined;
    get dnsSuffix(): string;
    get externalInboundIpAddresses(): string[];
    get id(): string;
    inboundNetworkDependencies(index: string): AppServiceEnvironmentV3InboundNetworkDependencies;
    get internalInboundIpAddresses(): string[];
    private _internalLoadBalancingMode?;
    get internalLoadBalancingMode(): string;
    set internalLoadBalancingMode(value: string);
    resetInternalLoadBalancingMode(): void;
    get internalLoadBalancingModeInput(): string | undefined;
    get ipSslAddressCount(): number;
    get linuxOutboundIpAddresses(): string[];
    get location(): string;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    get pricingTier(): string;
    private _resourceGroupName?;
    get resourceGroupName(): string;
    set resourceGroupName(value: string);
    get resourceGroupNameInput(): string | undefined;
    private _subnetId?;
    get subnetId(): string;
    set subnetId(value: string);
    get subnetIdInput(): string | undefined;
    private _tags?;
    get tags(): {
        [key: string]: string;
    };
    set tags(value: {
        [key: string]: string;
    });
    resetTags(): void;
    get tagsInput(): {
        [key: string]: string;
    } | undefined;
    get windowsOutboundIpAddresses(): string[];
    private _zoneRedundant?;
    get zoneRedundant(): boolean | cdktf.IResolvable;
    set zoneRedundant(value: boolean | cdktf.IResolvable);
    resetZoneRedundant(): void;
    get zoneRedundantInput(): boolean | cdktf.IResolvable | undefined;
    private _clusterSetting?;
    get clusterSetting(): AppServiceEnvironmentV3ClusterSetting[] | cdktf.IResolvable;
    set clusterSetting(value: AppServiceEnvironmentV3ClusterSetting[] | cdktf.IResolvable);
    resetClusterSetting(): void;
    get clusterSettingInput(): cdktf.IResolvable | AppServiceEnvironmentV3ClusterSetting[] | undefined;
    private _timeouts;
    get timeouts(): AppServiceEnvironmentV3TimeoutsOutputReference;
    putTimeouts(value: AppServiceEnvironmentV3Timeouts): void;
    resetTimeouts(): void;
    get timeoutsInput(): AppServiceEnvironmentV3Timeouts | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
