import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface ApplicationInsightsAnalyticsItemConfig extends cdktf.TerraformMetaArguments {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/application_insights_analytics_item#application_insights_id ApplicationInsightsAnalyticsItem#application_insights_id}
    */
    readonly applicationInsightsId: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/application_insights_analytics_item#content ApplicationInsightsAnalyticsItem#content}
    */
    readonly content: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/application_insights_analytics_item#function_alias ApplicationInsightsAnalyticsItem#function_alias}
    */
    readonly functionAlias?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/application_insights_analytics_item#name ApplicationInsightsAnalyticsItem#name}
    */
    readonly name: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/application_insights_analytics_item#scope ApplicationInsightsAnalyticsItem#scope}
    */
    readonly scope: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/application_insights_analytics_item#type ApplicationInsightsAnalyticsItem#type}
    */
    readonly type: string;
    /**
    * timeouts block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/application_insights_analytics_item#timeouts ApplicationInsightsAnalyticsItem#timeouts}
    */
    readonly timeouts?: ApplicationInsightsAnalyticsItemTimeouts;
}
export interface ApplicationInsightsAnalyticsItemTimeouts {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/application_insights_analytics_item#create ApplicationInsightsAnalyticsItem#create}
    */
    readonly create?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/application_insights_analytics_item#delete ApplicationInsightsAnalyticsItem#delete}
    */
    readonly delete?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/application_insights_analytics_item#read ApplicationInsightsAnalyticsItem#read}
    */
    readonly read?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/application_insights_analytics_item#update ApplicationInsightsAnalyticsItem#update}
    */
    readonly update?: string;
}
export declare function applicationInsightsAnalyticsItemTimeoutsToTerraform(struct?: ApplicationInsightsAnalyticsItemTimeoutsOutputReference | ApplicationInsightsAnalyticsItemTimeouts | cdktf.IResolvable): any;
export declare class ApplicationInsightsAnalyticsItemTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param isSingleItem True if this is a block, false if it's a list
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, isSingleItem: boolean);
    get internalValue(): ApplicationInsightsAnalyticsItemTimeouts | undefined;
    set internalValue(value: ApplicationInsightsAnalyticsItemTimeouts | undefined);
    private _create?;
    get create(): string;
    set create(value: string);
    resetCreate(): void;
    get createInput(): string | undefined;
    private _delete?;
    get delete(): string;
    set delete(value: string);
    resetDelete(): void;
    get deleteInput(): string | undefined;
    private _read?;
    get read(): string;
    set read(value: string);
    resetRead(): void;
    get readInput(): string | undefined;
    private _update?;
    get update(): string;
    set update(value: string);
    resetUpdate(): void;
    get updateInput(): string | undefined;
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/azurerm/r/application_insights_analytics_item azurerm_application_insights_analytics_item}
*/
export declare class ApplicationInsightsAnalyticsItem extends cdktf.TerraformResource {
    static readonly tfResourceType: string;
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/azurerm/r/application_insights_analytics_item azurerm_application_insights_analytics_item} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options ApplicationInsightsAnalyticsItemConfig
    */
    constructor(scope: Construct, id: string, config: ApplicationInsightsAnalyticsItemConfig);
    private _applicationInsightsId?;
    get applicationInsightsId(): string;
    set applicationInsightsId(value: string);
    get applicationInsightsIdInput(): string | undefined;
    private _content?;
    get content(): string;
    set content(value: string);
    get contentInput(): string | undefined;
    private _functionAlias?;
    get functionAlias(): string;
    set functionAlias(value: string);
    resetFunctionAlias(): void;
    get functionAliasInput(): string | undefined;
    get id(): string;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    private _scope?;
    get scope(): string;
    set scope(value: string);
    get scopeInput(): string | undefined;
    get timeCreated(): string;
    get timeModified(): string;
    private _type?;
    get type(): string;
    set type(value: string);
    get typeInput(): string | undefined;
    get version(): string;
    private _timeouts;
    get timeouts(): ApplicationInsightsAnalyticsItemTimeoutsOutputReference;
    putTimeouts(value: ApplicationInsightsAnalyticsItemTimeouts): void;
    resetTimeouts(): void;
    get timeoutsInput(): ApplicationInsightsAnalyticsItemTimeouts | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
