import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface AutomationVariableIntConfig extends cdktf.TerraformMetaArguments {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/automation_variable_int#automation_account_name AutomationVariableInt#automation_account_name}
    */
    readonly automationAccountName: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/automation_variable_int#description AutomationVariableInt#description}
    */
    readonly description?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/automation_variable_int#encrypted AutomationVariableInt#encrypted}
    */
    readonly encrypted?: boolean | cdktf.IResolvable;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/automation_variable_int#name AutomationVariableInt#name}
    */
    readonly name: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/automation_variable_int#resource_group_name AutomationVariableInt#resource_group_name}
    */
    readonly resourceGroupName: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/automation_variable_int#value AutomationVariableInt#value}
    */
    readonly value?: number;
    /**
    * timeouts block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/automation_variable_int#timeouts AutomationVariableInt#timeouts}
    */
    readonly timeouts?: AutomationVariableIntTimeouts;
}
export interface AutomationVariableIntTimeouts {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/automation_variable_int#create AutomationVariableInt#create}
    */
    readonly create?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/automation_variable_int#delete AutomationVariableInt#delete}
    */
    readonly delete?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/automation_variable_int#read AutomationVariableInt#read}
    */
    readonly read?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/automation_variable_int#update AutomationVariableInt#update}
    */
    readonly update?: string;
}
export declare function automationVariableIntTimeoutsToTerraform(struct?: AutomationVariableIntTimeoutsOutputReference | AutomationVariableIntTimeouts | cdktf.IResolvable): any;
export declare class AutomationVariableIntTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param isSingleItem True if this is a block, false if it's a list
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, isSingleItem: boolean);
    get internalValue(): AutomationVariableIntTimeouts | undefined;
    set internalValue(value: AutomationVariableIntTimeouts | undefined);
    private _create?;
    get create(): string;
    set create(value: string);
    resetCreate(): void;
    get createInput(): string | undefined;
    private _delete?;
    get delete(): string;
    set delete(value: string);
    resetDelete(): void;
    get deleteInput(): string | undefined;
    private _read?;
    get read(): string;
    set read(value: string);
    resetRead(): void;
    get readInput(): string | undefined;
    private _update?;
    get update(): string;
    set update(value: string);
    resetUpdate(): void;
    get updateInput(): string | undefined;
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/azurerm/r/automation_variable_int azurerm_automation_variable_int}
*/
export declare class AutomationVariableInt extends cdktf.TerraformResource {
    static readonly tfResourceType: string;
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/azurerm/r/automation_variable_int azurerm_automation_variable_int} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options AutomationVariableIntConfig
    */
    constructor(scope: Construct, id: string, config: AutomationVariableIntConfig);
    private _automationAccountName?;
    get automationAccountName(): string;
    set automationAccountName(value: string);
    get automationAccountNameInput(): string | undefined;
    private _description?;
    get description(): string;
    set description(value: string);
    resetDescription(): void;
    get descriptionInput(): string | undefined;
    private _encrypted?;
    get encrypted(): boolean | cdktf.IResolvable;
    set encrypted(value: boolean | cdktf.IResolvable);
    resetEncrypted(): void;
    get encryptedInput(): boolean | cdktf.IResolvable | undefined;
    get id(): string;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    private _resourceGroupName?;
    get resourceGroupName(): string;
    set resourceGroupName(value: string);
    get resourceGroupNameInput(): string | undefined;
    private _value?;
    get value(): number;
    set value(value: number);
    resetValue(): void;
    get valueInput(): number | undefined;
    private _timeouts;
    get timeouts(): AutomationVariableIntTimeoutsOutputReference;
    putTimeouts(value: AutomationVariableIntTimeouts): void;
    resetTimeouts(): void;
    get timeoutsInput(): AutomationVariableIntTimeouts | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
