import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface DataAzurermAppConfigurationConfig extends cdktf.TerraformMetaArguments {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/d/app_configuration#name DataAzurermAppConfiguration#name}
    */
    readonly name: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/d/app_configuration#resource_group_name DataAzurermAppConfiguration#resource_group_name}
    */
    readonly resourceGroupName: string;
    /**
    * timeouts block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/d/app_configuration#timeouts DataAzurermAppConfiguration#timeouts}
    */
    readonly timeouts?: DataAzurermAppConfigurationTimeouts;
}
export declare class DataAzurermAppConfigurationPrimaryReadKey extends cdktf.ComplexComputedList {
    get connectionString(): string;
    get id(): string;
    get secret(): string;
}
export declare class DataAzurermAppConfigurationPrimaryWriteKey extends cdktf.ComplexComputedList {
    get connectionString(): string;
    get id(): string;
    get secret(): string;
}
export declare class DataAzurermAppConfigurationSecondaryReadKey extends cdktf.ComplexComputedList {
    get connectionString(): string;
    get id(): string;
    get secret(): string;
}
export declare class DataAzurermAppConfigurationSecondaryWriteKey extends cdktf.ComplexComputedList {
    get connectionString(): string;
    get id(): string;
    get secret(): string;
}
export interface DataAzurermAppConfigurationTimeouts {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/d/app_configuration#read DataAzurermAppConfiguration#read}
    */
    readonly read?: string;
}
export declare function dataAzurermAppConfigurationTimeoutsToTerraform(struct?: DataAzurermAppConfigurationTimeoutsOutputReference | DataAzurermAppConfigurationTimeouts | cdktf.IResolvable): any;
export declare class DataAzurermAppConfigurationTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param isSingleItem True if this is a block, false if it's a list
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, isSingleItem: boolean);
    get internalValue(): DataAzurermAppConfigurationTimeouts | undefined;
    set internalValue(value: DataAzurermAppConfigurationTimeouts | undefined);
    private _read?;
    get read(): string;
    set read(value: string);
    resetRead(): void;
    get readInput(): string | undefined;
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/azurerm/d/app_configuration azurerm_app_configuration}
*/
export declare class DataAzurermAppConfiguration extends cdktf.TerraformDataSource {
    static readonly tfResourceType: string;
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/azurerm/d/app_configuration azurerm_app_configuration} Data Source
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options DataAzurermAppConfigurationConfig
    */
    constructor(scope: Construct, id: string, config: DataAzurermAppConfigurationConfig);
    get endpoint(): string;
    get id(): string;
    get location(): string;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    primaryReadKey(index: string): DataAzurermAppConfigurationPrimaryReadKey;
    primaryWriteKey(index: string): DataAzurermAppConfigurationPrimaryWriteKey;
    private _resourceGroupName?;
    get resourceGroupName(): string;
    set resourceGroupName(value: string);
    get resourceGroupNameInput(): string | undefined;
    secondaryReadKey(index: string): DataAzurermAppConfigurationSecondaryReadKey;
    secondaryWriteKey(index: string): DataAzurermAppConfigurationSecondaryWriteKey;
    get sku(): string;
    tags(key: string): string | cdktf.IResolvable;
    private _timeouts;
    get timeouts(): DataAzurermAppConfigurationTimeoutsOutputReference;
    putTimeouts(value: DataAzurermAppConfigurationTimeouts): void;
    resetTimeouts(): void;
    get timeoutsInput(): DataAzurermAppConfigurationTimeouts | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
