import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface DataAzurermAppServicePlanConfig extends cdktf.TerraformMetaArguments {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/d/app_service_plan#name DataAzurermAppServicePlan#name}
    */
    readonly name: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/d/app_service_plan#resource_group_name DataAzurermAppServicePlan#resource_group_name}
    */
    readonly resourceGroupName: string;
    /**
    * timeouts block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/d/app_service_plan#timeouts DataAzurermAppServicePlan#timeouts}
    */
    readonly timeouts?: DataAzurermAppServicePlanTimeouts;
}
export declare class DataAzurermAppServicePlanSku extends cdktf.ComplexComputedList {
    get capacity(): number;
    get size(): string;
    get tier(): string;
}
export interface DataAzurermAppServicePlanTimeouts {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/d/app_service_plan#read DataAzurermAppServicePlan#read}
    */
    readonly read?: string;
}
export declare function dataAzurermAppServicePlanTimeoutsToTerraform(struct?: DataAzurermAppServicePlanTimeoutsOutputReference | DataAzurermAppServicePlanTimeouts | cdktf.IResolvable): any;
export declare class DataAzurermAppServicePlanTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param isSingleItem True if this is a block, false if it's a list
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, isSingleItem: boolean);
    get internalValue(): DataAzurermAppServicePlanTimeouts | undefined;
    set internalValue(value: DataAzurermAppServicePlanTimeouts | undefined);
    private _read?;
    get read(): string;
    set read(value: string);
    resetRead(): void;
    get readInput(): string | undefined;
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/azurerm/d/app_service_plan azurerm_app_service_plan}
*/
export declare class DataAzurermAppServicePlan extends cdktf.TerraformDataSource {
    static readonly tfResourceType: string;
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/azurerm/d/app_service_plan azurerm_app_service_plan} Data Source
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options DataAzurermAppServicePlanConfig
    */
    constructor(scope: Construct, id: string, config: DataAzurermAppServicePlanConfig);
    get appServiceEnvironmentId(): string;
    get id(): string;
    get isXenon(): cdktf.IResolvable;
    get kind(): string;
    get location(): string;
    get maximumElasticWorkerCount(): number;
    get maximumNumberOfWorkers(): number;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    get perSiteScaling(): cdktf.IResolvable;
    get reserved(): cdktf.IResolvable;
    private _resourceGroupName?;
    get resourceGroupName(): string;
    set resourceGroupName(value: string);
    get resourceGroupNameInput(): string | undefined;
    sku(index: string): DataAzurermAppServicePlanSku;
    tags(key: string): string | cdktf.IResolvable;
    get zoneRedundant(): cdktf.IResolvable;
    private _timeouts;
    get timeouts(): DataAzurermAppServicePlanTimeoutsOutputReference;
    putTimeouts(value: DataAzurermAppServicePlanTimeouts): void;
    resetTimeouts(): void;
    get timeoutsInput(): DataAzurermAppServicePlanTimeouts | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
