import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface DataAzurermContainerRegistryTokenConfig extends cdktf.TerraformMetaArguments {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/d/container_registry_token#container_registry_name DataAzurermContainerRegistryToken#container_registry_name}
    */
    readonly containerRegistryName: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/d/container_registry_token#name DataAzurermContainerRegistryToken#name}
    */
    readonly name: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/d/container_registry_token#resource_group_name DataAzurermContainerRegistryToken#resource_group_name}
    */
    readonly resourceGroupName: string;
    /**
    * timeouts block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/d/container_registry_token#timeouts DataAzurermContainerRegistryToken#timeouts}
    */
    readonly timeouts?: DataAzurermContainerRegistryTokenTimeouts;
}
export interface DataAzurermContainerRegistryTokenTimeouts {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/d/container_registry_token#read DataAzurermContainerRegistryToken#read}
    */
    readonly read?: string;
}
export declare function dataAzurermContainerRegistryTokenTimeoutsToTerraform(struct?: DataAzurermContainerRegistryTokenTimeoutsOutputReference | DataAzurermContainerRegistryTokenTimeouts | cdktf.IResolvable): any;
export declare class DataAzurermContainerRegistryTokenTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param isSingleItem True if this is a block, false if it's a list
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, isSingleItem: boolean);
    get internalValue(): DataAzurermContainerRegistryTokenTimeouts | undefined;
    set internalValue(value: DataAzurermContainerRegistryTokenTimeouts | undefined);
    private _read?;
    get read(): string;
    set read(value: string);
    resetRead(): void;
    get readInput(): string | undefined;
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/azurerm/d/container_registry_token azurerm_container_registry_token}
*/
export declare class DataAzurermContainerRegistryToken extends cdktf.TerraformDataSource {
    static readonly tfResourceType: string;
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/azurerm/d/container_registry_token azurerm_container_registry_token} Data Source
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options DataAzurermContainerRegistryTokenConfig
    */
    constructor(scope: Construct, id: string, config: DataAzurermContainerRegistryTokenConfig);
    private _containerRegistryName?;
    get containerRegistryName(): string;
    set containerRegistryName(value: string);
    get containerRegistryNameInput(): string | undefined;
    get enabled(): cdktf.IResolvable;
    get id(): string;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    private _resourceGroupName?;
    get resourceGroupName(): string;
    set resourceGroupName(value: string);
    get resourceGroupNameInput(): string | undefined;
    get scopeMapId(): string;
    private _timeouts;
    get timeouts(): DataAzurermContainerRegistryTokenTimeoutsOutputReference;
    putTimeouts(value: DataAzurermContainerRegistryTokenTimeouts): void;
    resetTimeouts(): void;
    get timeoutsInput(): DataAzurermContainerRegistryTokenTimeouts | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
