import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface DataAzurermDataLakeStoreConfig extends cdktf.TerraformMetaArguments {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/d/data_lake_store#name DataAzurermDataLakeStore#name}
    */
    readonly name: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/d/data_lake_store#resource_group_name DataAzurermDataLakeStore#resource_group_name}
    */
    readonly resourceGroupName: string;
    /**
    * timeouts block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/d/data_lake_store#timeouts DataAzurermDataLakeStore#timeouts}
    */
    readonly timeouts?: DataAzurermDataLakeStoreTimeouts;
}
export interface DataAzurermDataLakeStoreTimeouts {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/d/data_lake_store#read DataAzurermDataLakeStore#read}
    */
    readonly read?: string;
}
export declare function dataAzurermDataLakeStoreTimeoutsToTerraform(struct?: DataAzurermDataLakeStoreTimeoutsOutputReference | DataAzurermDataLakeStoreTimeouts | cdktf.IResolvable): any;
export declare class DataAzurermDataLakeStoreTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param isSingleItem True if this is a block, false if it's a list
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, isSingleItem: boolean);
    get internalValue(): DataAzurermDataLakeStoreTimeouts | undefined;
    set internalValue(value: DataAzurermDataLakeStoreTimeouts | undefined);
    private _read?;
    get read(): string;
    set read(value: string);
    resetRead(): void;
    get readInput(): string | undefined;
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/azurerm/d/data_lake_store azurerm_data_lake_store}
*/
export declare class DataAzurermDataLakeStore extends cdktf.TerraformDataSource {
    static readonly tfResourceType: string;
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/azurerm/d/data_lake_store azurerm_data_lake_store} Data Source
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options DataAzurermDataLakeStoreConfig
    */
    constructor(scope: Construct, id: string, config: DataAzurermDataLakeStoreConfig);
    get encryptionState(): string;
    get encryptionType(): string;
    get firewallAllowAzureIps(): string;
    get firewallState(): string;
    get id(): string;
    get location(): string;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    private _resourceGroupName?;
    get resourceGroupName(): string;
    set resourceGroupName(value: string);
    get resourceGroupNameInput(): string | undefined;
    tags(key: string): string | cdktf.IResolvable;
    get tier(): string;
    private _timeouts;
    get timeouts(): DataAzurermDataLakeStoreTimeoutsOutputReference;
    putTimeouts(value: DataAzurermDataLakeStoreTimeouts): void;
    resetTimeouts(): void;
    get timeoutsInput(): DataAzurermDataLakeStoreTimeouts | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
