import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface DataAzurermDataShareConfig extends cdktf.TerraformMetaArguments {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/d/data_share#account_id DataAzurermDataShare#account_id}
    */
    readonly accountId: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/d/data_share#name DataAzurermDataShare#name}
    */
    readonly name: string;
    /**
    * timeouts block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/d/data_share#timeouts DataAzurermDataShare#timeouts}
    */
    readonly timeouts?: DataAzurermDataShareTimeouts;
}
export declare class DataAzurermDataShareSnapshotSchedule extends cdktf.ComplexComputedList {
    get name(): string;
    get recurrence(): string;
    get startTime(): string;
}
export interface DataAzurermDataShareTimeouts {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/d/data_share#read DataAzurermDataShare#read}
    */
    readonly read?: string;
}
export declare function dataAzurermDataShareTimeoutsToTerraform(struct?: DataAzurermDataShareTimeoutsOutputReference | DataAzurermDataShareTimeouts | cdktf.IResolvable): any;
export declare class DataAzurermDataShareTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param isSingleItem True if this is a block, false if it's a list
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, isSingleItem: boolean);
    get internalValue(): DataAzurermDataShareTimeouts | undefined;
    set internalValue(value: DataAzurermDataShareTimeouts | undefined);
    private _read?;
    get read(): string;
    set read(value: string);
    resetRead(): void;
    get readInput(): string | undefined;
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/azurerm/d/data_share azurerm_data_share}
*/
export declare class DataAzurermDataShare extends cdktf.TerraformDataSource {
    static readonly tfResourceType: string;
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/azurerm/d/data_share azurerm_data_share} Data Source
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options DataAzurermDataShareConfig
    */
    constructor(scope: Construct, id: string, config: DataAzurermDataShareConfig);
    private _accountId?;
    get accountId(): string;
    set accountId(value: string);
    get accountIdInput(): string | undefined;
    get description(): string;
    get id(): string;
    get kind(): string;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    snapshotSchedule(index: string): DataAzurermDataShareSnapshotSchedule;
    get terms(): string;
    private _timeouts;
    get timeouts(): DataAzurermDataShareTimeoutsOutputReference;
    putTimeouts(value: DataAzurermDataShareTimeouts): void;
    resetTimeouts(): void;
    get timeoutsInput(): DataAzurermDataShareTimeouts | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
