import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface DataAzurermFunctionAppConfig extends cdktf.TerraformMetaArguments {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/d/function_app#name DataAzurermFunctionApp#name}
    */
    readonly name: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/d/function_app#resource_group_name DataAzurermFunctionApp#resource_group_name}
    */
    readonly resourceGroupName: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/d/function_app#tags DataAzurermFunctionApp#tags}
    */
    readonly tags?: {
        [key: string]: string;
    };
    /**
    * timeouts block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/d/function_app#timeouts DataAzurermFunctionApp#timeouts}
    */
    readonly timeouts?: DataAzurermFunctionAppTimeouts;
}
export declare class DataAzurermFunctionAppConnectionString extends cdktf.ComplexComputedList {
    get name(): string;
    get type(): string;
    get value(): string;
}
export declare class DataAzurermFunctionAppIdentity extends cdktf.ComplexComputedList {
    get identityIds(): string[];
    get principalId(): string;
    get tenantId(): string;
    get type(): string;
}
export declare class DataAzurermFunctionAppSiteConfigCors extends cdktf.ComplexComputedList {
    get allowedOrigins(): string[];
    get supportCredentials(): cdktf.IResolvable;
}
export declare class DataAzurermFunctionAppSiteConfigIpRestrictionHeaders extends cdktf.ComplexComputedList {
    get xAzureFdid(): string[];
    get xFdHealthProbe(): string[];
    get xForwardedFor(): string[];
    get xForwardedHost(): string[];
}
export declare class DataAzurermFunctionAppSiteConfigIpRestriction extends cdktf.ComplexComputedList {
    get action(): string;
    get headers(): cdktf.IResolvable;
    get ipAddress(): string;
    get name(): string;
    get priority(): number;
    get serviceTag(): string;
    get virtualNetworkSubnetId(): string;
}
export declare class DataAzurermFunctionAppSiteConfigScmIpRestrictionHeaders extends cdktf.ComplexComputedList {
    get xAzureFdid(): string[];
    get xFdHealthProbe(): string[];
    get xForwardedFor(): string[];
    get xForwardedHost(): string[];
}
export declare class DataAzurermFunctionAppSiteConfigScmIpRestriction extends cdktf.ComplexComputedList {
    get action(): string;
    get headers(): cdktf.IResolvable;
    get ipAddress(): string;
    get name(): string;
    get priority(): number;
    get serviceTag(): string;
    get virtualNetworkSubnetId(): string;
}
export declare class DataAzurermFunctionAppSiteConfig extends cdktf.ComplexComputedList {
    get alwaysOn(): cdktf.IResolvable;
    get appScaleLimit(): number;
    get autoSwapSlotName(): string;
    get cors(): cdktf.IResolvable;
    get dotnetFrameworkVersion(): string;
    get elasticInstanceMinimum(): number;
    get ftpsState(): string;
    get healthCheckPath(): string;
    get http2Enabled(): cdktf.IResolvable;
    get ipRestriction(): cdktf.IResolvable;
    get javaVersion(): string;
    get linuxFxVersion(): string;
    get minTlsVersion(): string;
    get preWarmedInstanceCount(): number;
    get runtimeScaleMonitoringEnabled(): cdktf.IResolvable;
    get scmIpRestriction(): cdktf.IResolvable;
    get scmType(): string;
    get scmUseMainIpRestriction(): cdktf.IResolvable;
    get use32BitWorkerProcess(): cdktf.IResolvable;
    get vnetRouteAllEnabled(): cdktf.IResolvable;
    get websocketsEnabled(): cdktf.IResolvable;
}
export declare class DataAzurermFunctionAppSiteCredential extends cdktf.ComplexComputedList {
    get password(): string;
    get username(): string;
}
export declare class DataAzurermFunctionAppSourceControl extends cdktf.ComplexComputedList {
    get branch(): string;
    get manualIntegration(): cdktf.IResolvable;
    get repoUrl(): string;
    get rollbackEnabled(): cdktf.IResolvable;
    get useMercurial(): cdktf.IResolvable;
}
export interface DataAzurermFunctionAppTimeouts {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/d/function_app#read DataAzurermFunctionApp#read}
    */
    readonly read?: string;
}
export declare function dataAzurermFunctionAppTimeoutsToTerraform(struct?: DataAzurermFunctionAppTimeoutsOutputReference | DataAzurermFunctionAppTimeouts | cdktf.IResolvable): any;
export declare class DataAzurermFunctionAppTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param isSingleItem True if this is a block, false if it's a list
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, isSingleItem: boolean);
    get internalValue(): DataAzurermFunctionAppTimeouts | undefined;
    set internalValue(value: DataAzurermFunctionAppTimeouts | undefined);
    private _read?;
    get read(): string;
    set read(value: string);
    resetRead(): void;
    get readInput(): string | undefined;
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/azurerm/d/function_app azurerm_function_app}
*/
export declare class DataAzurermFunctionApp extends cdktf.TerraformDataSource {
    static readonly tfResourceType: string;
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/azurerm/d/function_app azurerm_function_app} Data Source
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options DataAzurermFunctionAppConfig
    */
    constructor(scope: Construct, id: string, config: DataAzurermFunctionAppConfig);
    get appServicePlanId(): string;
    appSettings(key: string): string | cdktf.IResolvable;
    get clientCertMode(): string;
    connectionString(index: string): DataAzurermFunctionAppConnectionString;
    get customDomainVerificationId(): string;
    get defaultHostname(): string;
    get enabled(): cdktf.IResolvable;
    get id(): string;
    identity(index: string): DataAzurermFunctionAppIdentity;
    get location(): string;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    get osType(): string;
    get outboundIpAddresses(): string;
    get possibleOutboundIpAddresses(): string;
    private _resourceGroupName?;
    get resourceGroupName(): string;
    set resourceGroupName(value: string);
    get resourceGroupNameInput(): string | undefined;
    siteConfig(index: string): DataAzurermFunctionAppSiteConfig;
    siteCredential(index: string): DataAzurermFunctionAppSiteCredential;
    sourceControl(index: string): DataAzurermFunctionAppSourceControl;
    private _tags?;
    get tags(): {
        [key: string]: string;
    };
    set tags(value: {
        [key: string]: string;
    });
    resetTags(): void;
    get tagsInput(): {
        [key: string]: string;
    } | undefined;
    private _timeouts;
    get timeouts(): DataAzurermFunctionAppTimeoutsOutputReference;
    putTimeouts(value: DataAzurermFunctionAppTimeouts): void;
    resetTimeouts(): void;
    get timeoutsInput(): DataAzurermFunctionAppTimeouts | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
